/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.util;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionUtil {
    private static Logger log = LoggerFactory.getLogger(HttpConnectionUtil.class);
    private static final String userAgent = "Mozilla/4.0 (compatible; Red5 Server)";
    private static PoolingHttpClientConnectionManager connectionManager;
    private static int connectionTimeout;

    static {
        connectionTimeout = 7000;
        connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(40);
    }

    public static final HttpClient getClient() {
        return HttpConnectionUtil.getClient(connectionTimeout);
    }

    public static final HttpClient getClient(int timeout) {
        HttpClientBuilder client = HttpClientBuilder.create();
        client.setConnectionManager((HttpClientConnectionManager)connectionManager);
        client.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout).build();
        client.setDefaultRequestConfig(config);
        client.disableRedirectHandling();
        client.setUserAgent(userAgent);
        if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
            HttpHost proxy = new HttpHost(System.getProperty("http.proxyHost").toString(), Integer.valueOf(System.getProperty("http.proxyPort")).intValue());
            client.setProxy(proxy);
        }
        return client.build();
    }

    public static final HttpClient getSecureClient() {
        HttpClientBuilder client = HttpClientBuilder.create();
        client.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        client.setConnectionManager((HttpClientConnectionManager)connectionManager);
        client.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        RequestConfig config = RequestConfig.custom().setSocketTimeout(connectionTimeout).build();
        client.setDefaultRequestConfig(config);
        client.disableRedirectHandling();
        client.setUserAgent(userAgent);
        return client.build();
    }

    public static void handleError(HttpResponse response) throws ParseException, IOException {
        log.debug("{}", (Object)response.getStatusLine().toString());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            log.debug("{}", (Object)EntityUtils.toString((HttpEntity)entity));
        }
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        HttpConnectionUtil.connectionTimeout = connectionTimeout;
    }
}

