/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.scope.IScopeService;
import org.red5.server.api.scope.ScopeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ScopeUtils {
    private static final Logger log = LoggerFactory.getLogger(ScopeUtils.class);
    private static final String SERVICE_CACHE_PREFIX = "__service_cache:";
    private static final String SLASH = "/";

    public static IScope resolveScope(IScope from, String path) {
        log.debug("resolveScope from: {} path: {}", (Object)from.getName(), (Object)path);
        IScope current = from;
        if (path.startsWith(SLASH)) {
            current = ScopeUtils.findRoot(current);
            path = path.substring(1, path.length());
        }
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        log.trace("Current: {}", (Object)current);
        Object[] parts = path.split(SLASH);
        if (log.isTraceEnabled()) {
            log.trace("Parts: {}", (Object)Arrays.toString(parts));
        }
        Object[] objectArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Object part = objectArray[n2];
            log.trace("Part: {}", part);
            if (!((String)part).equals(".")) {
                if (((String)part).equals("..")) {
                    if (!current.hasParent()) {
                        return null;
                    }
                    current = current.getParent();
                } else {
                    if (!current.hasChildScope((String)part)) {
                        return null;
                    }
                    current = current.getScope((String)part);
                    log.trace("Current: {}", (Object)current);
                }
            }
            ++n2;
        }
        return current;
    }

    public static IScope findRoot(IScope from) {
        IScope current = from;
        while (current.hasParent()) {
            current = current.getParent();
        }
        return current;
    }

    public static IScope findApplication(IScope from) {
        IScope current = from;
        while (current.hasParent() && !current.getType().equals((Object)ScopeType.APPLICATION)) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean isAncestor(IBasicScope from, IBasicScope ancestor) {
        IBasicScope current = from;
        while (current.hasParent()) {
            if (!(current = current.getParent()).equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoot(IBasicScope scope) {
        return !scope.hasParent();
    }

    public static boolean isGlobal(IBasicScope scope) {
        return scope.getType().equals((Object)ScopeType.GLOBAL);
    }

    public static boolean isApp(IBasicScope scope) {
        return scope.getType().equals((Object)ScopeType.APPLICATION);
    }

    public static boolean isRoom(IBasicScope scope) {
        return scope.getType().equals((Object)ScopeType.ROOM);
    }

    protected static Object getScopeService(IScope scope, String name) {
        return ScopeUtils.getScopeService(scope, name, null);
    }

    protected static Object getScopeService(IScope scope, String name, Class<?> defaultClass) {
        if (scope != null) {
            Object result;
            IContext context = scope.getContext();
            ApplicationContext appCtx = context.getApplicationContext();
            if (!appCtx.containsBean(name)) {
                if (defaultClass == null) {
                    return null;
                }
                try {
                    result = defaultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.error("{}", (Throwable)e);
                    return null;
                }
            } else {
                result = appCtx.getBean(name);
            }
            return result;
        }
        return null;
    }

    public static Object getScopeService(IScope scope, Class<?> intf) {
        return ScopeUtils.getScopeService(scope, intf, null);
    }

    public static Object getScopeService(IScope scope, Class<?> intf, boolean checkHandler) {
        return ScopeUtils.getScopeService(scope, intf, null, checkHandler);
    }

    public static Object getScopeService(IScope scope, Class<?> intf, Class<?> defaultClass) {
        return ScopeUtils.getScopeService(scope, intf, defaultClass, true);
    }

    public static Object getScopeService(IScope scope, Class<?> intf, Class<?> defaultClass, boolean checkHandler) {
        Object handler;
        String attr;
        block13: {
            if (scope == null || intf == null) {
                return null;
            }
            assert (intf.isInterface());
            attr = String.format("%s%s%s", "_transient", SERVICE_CACHE_PREFIX, intf.getCanonicalName());
            if (scope.hasAttribute(attr)) {
                return scope.getAttribute(attr);
            }
            handler = null;
            if (checkHandler) {
                IScope current = scope;
                while (current != null) {
                    IScopeHandler scopeHandler = current.getHandler();
                    if (intf.isInstance(scopeHandler)) {
                        handler = scopeHandler;
                        break;
                    }
                    if (!current.hasParent()) break;
                    current = current.getParent();
                }
            }
            if (handler == null && IScopeService.class.isAssignableFrom(intf)) {
                Field key = null;
                Object serviceName = null;
                try {
                    key = intf.getField("BEAN_NAME");
                    serviceName = key.get(null);
                    handler = ScopeUtils.getScopeService(scope, serviceName.toString(), defaultClass);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block13;
                    if (key == null) {
                        log.debug("No string field 'BEAN_NAME' in interface {}", (Object)intf.getName());
                    }
                    log.warn("Exception getting scope service using {}", (Object)intf.getName(), (Object)e);
                }
            }
        }
        if (handler == null && defaultClass != null) {
            try {
                handler = defaultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        scope.setAttribute(attr, handler);
        return handler;
    }
}

