/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.red5.server.so.ISharedObjectEvent;

public class SharedObjectEvent
implements ISharedObjectEvent,
Externalizable,
Comparable<SharedObjectEvent> {
    private static final long serialVersionUID = -4129018814289863535L;
    private long ts = System.nanoTime();
    private ISharedObjectEvent.Type type;
    private String key;
    private Object value;

    public SharedObjectEvent() {
    }

    public SharedObjectEvent(ISharedObjectEvent.Type type, String key, Object value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public long getTimestamp() {
        return this.ts;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ISharedObjectEvent.Type getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharedObjectEvent other = (SharedObjectEvent)obj;
        if (this.ts != other.getTimestamp()) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return String.format("SharedObjectEvent(%s, key: %s value: %s)", new Object[]{this.getType(), this.getKey(), this.getValue()});
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = ISharedObjectEvent.Type.valueOf(in.readUTF());
        this.key = in.readUTF();
        this.value = in.readObject();
        this.ts = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.type.name());
        out.writeUTF(this.key);
        out.writeObject(this.value);
        out.writeLong(this.ts);
    }

    @Override
    public int compareTo(SharedObjectEvent other) {
        return Long.compare(this.ts, other.getTimestamp());
    }
}

