/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.protocol;

public class RTMPDecodeState {
    public final String sessionId;
    private volatile int decoderBufferAmount;
    private volatile State decoderState = State.OK;

    public RTMPDecodeState(String sessionId) {
        this.sessionId = sessionId;
    }

    public int getDecoderBufferAmount() {
        return this.decoderBufferAmount;
    }

    public void bufferDecoding(int amount) {
        this.decoderState = State.BUFFER;
        this.decoderBufferAmount = amount;
    }

    public void continueDecoding() {
        this.decoderState = State.CONTINUE;
    }

    public boolean canStartDecoding(int remaining) {
        return remaining >= this.decoderBufferAmount;
    }

    public void startDecoding() {
        this.decoderState = State.OK;
        this.decoderBufferAmount = 0;
    }

    public void stopDecoding() {
        this.decoderState = State.DESTROYED;
    }

    public boolean hasDecodedObject() {
        return this.decoderState == State.OK;
    }

    public boolean canContinueDecoding() {
        return this.decoderState != State.BUFFER && this.decoderState != State.DESTROYED;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "RTMPDecodeState [sessionId=" + this.sessionId + ", decoderState=" + this.decoderState + ", decoderBufferAmount=" + this.decoderBufferAmount + "]";
    }

    private static enum State {
        OK,
        CONTINUE,
        BUFFER,
        DESTROYED;

    }
}

