/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.LinkedList;
import java.util.Queue;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.message.RTMPMessage;

public class PlayBuffer {
    private long capacity;
    private long messageSize;
    private Queue<RTMPMessage> messageQueue = new LinkedList<RTMPMessage>();

    public PlayBuffer(long capacity) {
        this.capacity = capacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public int getMessageCount() {
        return this.messageQueue.size();
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public boolean putMessage(RTMPMessage message) {
        IRTMPEvent body = message.getBody();
        if (!(body instanceof IStreamData)) {
            throw new RuntimeException("Expected IStreamData but got " + body);
        }
        int size = ((IStreamData)body).getData().limit();
        if (this.messageSize + (long)size > this.capacity) {
            return false;
        }
        this.messageSize += (long)size;
        this.messageQueue.offer(message);
        return true;
    }

    public RTMPMessage takeMessage() {
        RTMPMessage message = this.messageQueue.poll();
        if (message != null) {
            IRTMPEvent body = message.getBody();
            if (!(body instanceof IStreamData)) {
                throw new RuntimeException("Expected IStreamData but got " + body);
            }
            this.messageSize -= (long)((IStreamData)body).getData().limit();
        }
        return message;
    }

    public RTMPMessage peekMessage() {
        return this.messageQueue.peek();
    }

    public void clear() {
        this.messageQueue.clear();
        this.messageSize = 0L;
    }
}

