/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpe;

import javax.crypto.Cipher;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPMinaCodecFactory;
import org.red5.server.net.rtmpe.EncryptedWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPEIoFilter
extends IoFilterAdapter {
    private static final Logger log = LoggerFactory.getLogger(RTMPEIoFilter.class);

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object obj) throws Exception {
        String sessionId;
        if (log.isTraceEnabled()) {
            log.trace("messageReceived nextFilter: {} session: {} message: {}", new Object[]{nextFilter, session, obj});
        }
        if ((sessionId = (String)session.getAttribute((Object)"rtmp.sessionid")) != null) {
            RTMPMinaConnection conn;
            if (log.isTraceEnabled()) {
                log.trace("RTMP Session id: {}", (Object)sessionId);
            }
            if ((conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId)) == null) {
                throw new Exception("Receive on unavailable connection - session id: " + sessionId);
            }
            RTMP rtmp = conn.getState();
            byte connectionState = conn.getStateCode();
            IoBuffer message = (IoBuffer)obj;
            InboundHandshake handshake = null;
            switch (connectionState) {
                case 0: {
                    IoBuffer s1;
                    handshake = (InboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                    handshake.addBuffer(message);
                    int c0c1Size = handshake.getBufferSize();
                    log.trace("Incoming C0C1 size: {}", (Object)c0c1Size);
                    if (c0c1Size < 1537) break;
                    log.debug("decodeHandshakeC0C1");
                    IoBuffer buf = handshake.getBufferAsIoBuffer();
                    byte connectionType = buf.get();
                    handshake.setHandshakeType(connectionType);
                    log.trace("Incoming C0 connection type: {}", (Object)connectionType);
                    byte[] dst = new byte[1536];
                    buf.get(dst);
                    rtmp.setState((byte)1);
                    int remaining = buf.remaining();
                    if (remaining > 0) {
                        handshake.addBuffer(buf);
                        log.trace("Stored {} bytes for later decoding", (Object)remaining);
                    }
                    if ((s1 = handshake.decodeClientRequest1(IoBuffer.wrap((byte[])dst))) != null) {
                        session.write((Object)s1);
                        break;
                    }
                    log.warn("Client was rejected due to invalid handshake");
                    conn.close();
                    break;
                }
                case 1: {
                    handshake = (InboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                    handshake.addBuffer(message);
                    int c2Size = handshake.getBufferSize();
                    log.trace("Incoming C2 size: {}", (Object)c2Size);
                    if (c2Size < 1536) break;
                    log.debug("decodeHandshakeC2");
                    IoBuffer buf = handshake.getBufferAsIoBuffer();
                    byte[] dst = new byte[1536];
                    buf.get(dst);
                    if (handshake.decodeClientRequest2(IoBuffer.wrap((byte[])dst))) {
                        log.debug("Connected, removing handshake data and adding rtmp protocol filter");
                        rtmp.setState((byte)2);
                        if (handshake.useEncryption()) {
                            log.debug("Using encrypted communications, adding ciphers to the session");
                            rtmp.setEncrypted(true);
                            session.setAttribute((Object)"rtmpe.cipher.in", (Object)handshake.getCipherIn());
                            session.setAttribute((Object)"rtmpe.cipher.out", (Object)handshake.getCipherOut());
                        }
                        session.removeAttribute((Object)"rtmp.handshake");
                        log.debug("Adding RTMP protocol filter");
                        session.getFilterChain().addAfter("rtmpeFilter", "protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RTMPMinaCodecFactory()));
                        if (!buf.hasRemaining()) break;
                        log.trace("Receiving message: {}", (Object)buf);
                        nextFilter.messageReceived(session, (Object)buf);
                        break;
                    }
                    log.warn("Client was rejected due to invalid handshake");
                    conn.close();
                    break;
                }
                case 2: {
                    if (!rtmp.isEncrypted()) {
                        log.trace("Receiving message: {}", (Object)message);
                        nextFilter.messageReceived(session, (Object)message);
                        break;
                    }
                    Cipher cipher = (Cipher)session.getAttribute((Object)"rtmpe.cipher.in");
                    if (cipher == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug("Decrypting message: {}", (Object)message);
                    }
                    byte[] encrypted = new byte[message.remaining()];
                    message.get(encrypted);
                    message.free();
                    byte[] plain = cipher.update(encrypted);
                    IoBuffer messageDecrypted = IoBuffer.wrap((byte[])plain);
                    if (log.isDebugEnabled()) {
                        log.debug("Receiving decrypted message: {}", (Object)messageDecrypted);
                    }
                    nextFilter.messageReceived(session, (Object)messageDecrypted);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                }
            }
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest request) throws Exception {
        log.trace("filterWrite nextFilter: {} session: {} request: {}", new Object[]{nextFilter, session, request});
        Cipher cipher = (Cipher)session.getAttribute((Object)"rtmpe.cipher.out");
        if (cipher == null) {
            if (log.isTraceEnabled()) {
                log.trace("Writing message");
            }
            nextFilter.filterWrite(session, request);
        } else {
            IoBuffer message = (IoBuffer)request.getMessage();
            if (!message.hasRemaining()) {
                if (log.isTraceEnabled()) {
                    log.trace("Ignoring empty message");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Encrypting message: {}", (Object)message);
                }
                byte[] plain = new byte[message.remaining()];
                message.get(plain);
                message.free();
                byte[] encrypted = cipher.update(plain);
                IoBuffer messageEncrypted = IoBuffer.wrap((byte[])encrypted);
                if (log.isDebugEnabled()) {
                    log.debug("Writing encrypted message: {}", (Object)messageEncrypted);
                }
                nextFilter.filterWrite(session, (WriteRequest)new EncryptedWriteRequest(request, messageEncrypted));
            }
        }
    }
}

