/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.websocket.WsSession;
import org.red5.net.websocket.WebSocketScope;
import org.red5.server.AttributeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends AttributeStore
implements Comparable<WebSocketConnection> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnection.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean isDebug = log.isDebugEnabled();
    private static boolean useAsync = !System.getProperty("os.name").contains("Windows");
    private static long sendTimeout = 10000L;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private WeakReference<WsSession> wsSession;
    private WeakReference<WebSocketScope> scope;
    private final String wsSessionId;
    private final int hashCode;
    private String host;
    private String path;
    private String origin;
    private String userAgent = "undefined";
    private Map<String, List<String>> headers;
    private Map<String, Object> extensions = new HashMap<String, Object>();
    private Map<String, Object> querystringParameters = new HashMap<String, Object>();
    private String protocol;
    private volatile long readBytes;
    private volatile long writtenBytes;
    private Future<Void> sendFuture;

    public WebSocketConnection(WebSocketScope scope, Session session) {
        log.debug("New WebSocket - scope: {} session: {}", (Object)scope, (Object)session);
        this.scope = new WeakReference<WebSocketScope>(scope);
        this.path = scope.getPath();
        if (isDebug) {
            log.debug("path: {}", (Object)this.path);
        }
        this.wsSession = new WeakReference<WsSession>((WsSession)session);
        if (isDebug) {
            log.debug("ws session: {}", this.wsSession.get());
        }
        this.wsSessionId = session.getId();
        if (isDebug) {
            log.debug("wsSessionId: {}", (Object)this.wsSessionId);
        }
        this.hashCode = this.wsSessionId.hashCode();
        log.info("ws id: {} hashCode: {}", (Object)this.wsSessionId, (Object)this.hashCode);
        List extList = session.getNegotiatedExtensions();
        if (extList != null) {
            extList.forEach(extension -> this.extensions.put(extension.getName(), extension));
        }
        if (isDebug) {
            log.debug("extensions: {}", this.extensions);
        }
        String queryString = session.getQueryString();
        if (isDebug) {
            log.debug("queryString: {}", (Object)queryString);
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            String[] qsParams = queryString.split("&");
            Stream.of(qsParams).forEach(qsParam -> {
                String[] parts = qsParam.split("=");
                if (parts.length == 2) {
                    this.querystringParameters.put(parts[0], parts[1]);
                } else {
                    this.querystringParameters.put(parts[0], null);
                }
            });
        }
        Map pathParameters = session.getPathParameters();
        if (isDebug) {
            log.debug("pathParameters: {}", (Object)pathParameters);
        }
        Map userProps = session.getUserProperties();
        if (isDebug) {
            log.debug("userProps: {}", (Object)userProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String data) throws UnsupportedEncodingException, IOException {
        block18: {
            if (isDebug) {
                log.debug("send message: {}", (Object)data);
            }
            if (StringUtils.isNotBlank((CharSequence)data)) {
                WsSession session = (WsSession)this.wsSession.get();
                if (session != null && session.isOpen()) {
                    if (this.isConnected()) {
                        try {
                            if (useAsync) {
                                block17: {
                                    if (this.sendFuture != null && !this.sendFuture.isDone()) {
                                        try {
                                            this.sendFuture.get(sendTimeout, TimeUnit.MILLISECONDS);
                                        }
                                        catch (TimeoutException e) {
                                            log.warn("Send timed out {}", (Object)this.wsSessionId);
                                            if (this.isConnected()) break block17;
                                            this.sendFuture.cancel(true);
                                            return;
                                        }
                                    }
                                }
                                String e = this.wsSessionId;
                                synchronized (e) {
                                    int lengthToWrite = data.getBytes().length;
                                    this.sendFuture = session.getAsyncRemote().sendText(data);
                                    this.writtenBytes += (long)lengthToWrite;
                                    break block18;
                                }
                            }
                            String e = this.wsSessionId;
                            synchronized (e) {
                                int lengthToWrite = data.getBytes().length;
                                session.getBasicRemote().sendText(data);
                                this.writtenBytes += (long)lengthToWrite;
                                break block18;
                            }
                        }
                        catch (Exception e) {
                            if (this.isConnected()) {
                                log.warn("Send text exception", (Throwable)e);
                            }
                            break block18;
                        }
                    }
                    throw new IOException("WS connection closed");
                }
                throw new IOException("WS session closed");
            }
            throw new UnsupportedEncodingException("Cannot send a null string");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] buf) throws IOException {
        block16: {
            WsSession session;
            if (isDebug) {
                log.debug("send binary: {}", (Object)Arrays.toString(buf));
            }
            if ((session = (WsSession)this.wsSession.get()) != null && session.isOpen()) {
                try {
                    if (useAsync) {
                        block15: {
                            if (this.sendFuture != null && !this.sendFuture.isDone()) {
                                try {
                                    this.sendFuture.get(sendTimeout, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException e) {
                                    log.warn("Send timed out {}", (Object)this.wsSessionId);
                                    if (this.isConnected()) break block15;
                                    this.sendFuture.cancel(true);
                                    return;
                                }
                            }
                        }
                        String e = this.wsSessionId;
                        synchronized (e) {
                            this.sendFuture = session.getAsyncRemote().sendBinary(ByteBuffer.wrap(buf));
                            this.writtenBytes += (long)buf.length;
                            break block16;
                        }
                    }
                    String e = this.wsSessionId;
                    synchronized (e) {
                        session.getBasicRemote().sendBinary(ByteBuffer.wrap(buf));
                        this.writtenBytes += (long)buf.length;
                    }
                }
                catch (Exception e) {
                    log.warn("Send bytes exception", (Throwable)e);
                }
            } else {
                throw new IOException("WS session closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPing(byte[] buf) throws IllegalArgumentException, IOException {
        WsSession session;
        if (isTrace) {
            log.trace("send ping: {}", (Object)buf);
        }
        if ((session = (WsSession)this.wsSession.get()) != null && session.isOpen()) {
            String string = this.wsSessionId;
            synchronized (string) {
                session.getBasicRemote().sendPing(ByteBuffer.wrap(buf));
                this.writtenBytes += (long)buf.length;
            }
        } else {
            throw new IOException("WS session closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPong(byte[] buf) throws IllegalArgumentException, IOException {
        WsSession session;
        if (isTrace) {
            log.trace("send pong: {}", (Object)buf);
        }
        if ((session = (WsSession)this.wsSession.get()) != null && session.isOpen()) {
            String string = this.wsSessionId;
            synchronized (string) {
                session.getBasicRemote().sendPong(ByteBuffer.wrap(buf));
                this.writtenBytes += (long)buf.length;
            }
        } else {
            throw new IOException("WS session closed");
        }
    }

    public void close() {
        if (this.connected.compareAndSet(true, false)) {
            WsSession session;
            log.info("close: {}", (Object)this.wsSessionId);
            WsSession wsSession = session = this.wsSession != null ? (WsSession)this.wsSession.get() : null;
            if (session != null && session.isOpen()) {
                CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "");
                session.onClose(reason);
            }
            this.attributes.clear();
            if (this.querystringParameters != null) {
                this.querystringParameters.clear();
                this.querystringParameters = null;
            }
            if (this.extensions != null) {
                this.extensions.clear();
                this.extensions = null;
            }
            if (this.headers != null) {
                this.headers = null;
            }
            if (this.scope.get() != null) {
                ((WebSocketScope)this.scope.get()).removeConnection(this);
                this.wsSession.clear();
                this.scope.clear();
            }
        }
    }

    public static void setUseAsync(boolean useAsync) {
        if (!useAsync) {
            log.debug("Async websocket sends are disabled");
        }
        WebSocketConnection.useAsync = useAsync;
    }

    public WebSocketScope getScope() {
        return this.scope != null ? (WebSocketScope)this.scope.get() : null;
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public void setConnected() {
        boolean connectSuccess = this.connected.compareAndSet(false, true);
        log.debug("Connect success: {}", (Object)connectSuccess);
    }

    public String getHost() {
        return String.format("%s://%s%s", this.isSecure() ? "wss" : "ws", this.host, this.path);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isSecure() {
        Optional<WsSession> opt = Optional.ofNullable((WsSession)this.wsSession.get());
        if (opt.isPresent()) {
            return opt.get().isOpen() ? opt.get().isSecure() : false;
        }
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
    }

    public String getSessionId() {
        return this.wsSessionId;
    }

    @Deprecated(since="1.2.26")
    public void setHttpSessionId(String httpSessionId) {
    }

    @Deprecated(since="1.2.26")
    public String getHttpSessionId() {
        return this.wsSessionId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            Optional<List<String>> protocolHeader;
            List<String> originHeader;
            List<String> hostHeader;
            List<String> userAgentHeader = Optional.ofNullable(headers.get("User-Agent")).orElse(headers.get("User-Agent".toLowerCase()));
            if (userAgentHeader != null && !userAgentHeader.isEmpty()) {
                this.userAgent = userAgentHeader.get(0);
            }
            if ((hostHeader = Optional.ofNullable(headers.get("Host")).orElse(headers.get("Host".toLowerCase()))) != null && !hostHeader.isEmpty()) {
                this.host = hostHeader.get(0);
            }
            if ((originHeader = Optional.ofNullable(headers.get("Origin")).orElse(headers.get("Origin".toLowerCase()))) != null && !originHeader.isEmpty()) {
                this.origin = originHeader.get(0);
            }
            if ((protocolHeader = Optional.ofNullable(headers.get("Sec-WebSocket-Protocol"))).isPresent()) {
                if (isDebug) {
                    log.debug("Protocol header(s) exist: {}", protocolHeader.get());
                }
                this.protocol = protocolHeader.get().get(0);
            }
            if (isDebug) {
                log.debug("Set from headers - user-agent: {} host: {} origin: {}", new Object[]{this.userAgent, this.host, this.origin});
            }
            this.headers = headers;
        } else {
            this.headers = Collections.emptyMap();
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getQuerystringParameters() {
        return this.querystringParameters;
    }

    public void setQuerystringParameters(Map<String, Object> querystringParameters) {
        if (this.querystringParameters == null) {
            this.querystringParameters = new ConcurrentHashMap<String, Object>();
        }
        this.querystringParameters.putAll(querystringParameters);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String getExtensionsAsString() {
        String extensionsList = null;
        if (this.extensions != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.extensions.keySet()) {
                sb.append(key);
                sb.append("; ");
            }
            extensionsList = sb.toString().trim();
        }
        return extensionsList;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public static long getSendTimeout() {
        return sendTimeout;
    }

    public static void setSendTimeout(long sendTimeout) {
        WebSocketConnection.sendTimeout = sendTimeout;
    }

    public void setWsSessionTimeout(long idleTimeout) {
        if (this.wsSession != null) {
            ((WsSession)this.wsSession.get()).setMaxIdleTimeout(idleTimeout);
        }
    }

    public WsSession getWsSession() {
        return this.wsSession != null ? (WsSession)this.wsSession.get() : null;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public void updateReadBytes(long read) {
        this.readBytes += read;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public String getWsSessionId() {
        return this.wsSessionId;
    }

    @Override
    public int compareTo(WebSocketConnection that) {
        return Integer.compare(this.hashCode, that.hashCode);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketConnection other = (WebSocketConnection)obj;
        return this.hashCode == other.hashCode();
    }

    public String toString() {
        if (this.wsSessionId != null) {
            return "WebSocketConnection [wsId=" + this.wsSessionId + ", host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + ", secure=" + this.isSecure() + ", connected=" + this.connected + "]";
        }
        if (this.wsSession == null) {
            return "WebSocketConnection [wsId=not-set, host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + ", secure=not-set, connected=" + this.connected + "]";
        }
        return "WebSocketConnection [host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + " connected=false]";
    }
}

