/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.red5.net.websocket.server.WsWriteTimeout;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private final SocketWrapperBase<?> socketWrapper;
    private final UpgradeInfo upgradeInfo;
    private final WsWriteTimeout wsWriteTimeout;
    private volatile SendHandler handler;
    private volatile ByteBuffer[] buffers;
    private volatile long timeoutExpiry = -1L;
    private volatile boolean close;

    public WsRemoteEndpointImplServer(SocketWrapperBase<?> socketWrapper, UpgradeInfo upgradeInfo) {
        this.socketWrapper = socketWrapper;
        this.upgradeInfo = upgradeInfo;
        this.wsWriteTimeout = new WsWriteTimeout();
    }

    protected final boolean isMasked() {
        return false;
    }

    protected void doWrite(SendHandler handler, long blockingWriteTimeoutExpiry, ByteBuffer ... buffers) {
        if (blockingWriteTimeoutExpiry == -1L) {
            this.handler = handler;
            this.buffers = buffers;
            this.onWritePossible(true);
        } else {
            try {
                ByteBuffer[] byteBufferArray = buffers;
                int n = buffers.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer buffer = byteBufferArray[n2];
                    long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        SendResult sr = new SendResult((Throwable)new SocketTimeoutException());
                        handler.onResult(sr);
                        return;
                    }
                    this.socketWrapper.setWriteTimeout(timeout);
                    this.socketWrapper.write(true, buffer);
                    ++n2;
                }
                long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                if (timeout <= 0L) {
                    SendResult sr = new SendResult((Throwable)new SocketTimeoutException());
                    handler.onResult(sr);
                    return;
                }
                this.socketWrapper.setWriteTimeout(timeout);
                this.socketWrapper.flush(true);
                handler.onResult(SENDRESULT_OK);
            }
            catch (IOException e) {
                SendResult sr = new SendResult((Throwable)e);
                handler.onResult(sr);
            }
        }
    }

    protected void updateStats(long payloadLength) {
        this.upgradeInfo.addMsgsSent(1L);
        this.upgradeInfo.addBytesSent(payloadLength);
    }

    public void onWritePossible(boolean useDispatch) {
        long timeout;
        ByteBuffer[] buffers = this.buffers;
        if (buffers == null) {
            return;
        }
        boolean complete = false;
        try {
            this.socketWrapper.flush(false);
            while (this.socketWrapper.isReadyForWrite()) {
                complete = true;
                ByteBuffer[] byteBufferArray = buffers;
                int n = buffers.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer buffer = byteBufferArray[n2];
                    if (buffer.hasRemaining()) {
                        complete = false;
                        this.socketWrapper.write(false, buffer);
                        break;
                    }
                    ++n2;
                }
                if (!complete) continue;
                this.socketWrapper.flush(false);
                complete = this.socketWrapper.isReadyForWrite();
                if (complete) {
                    this.wsWriteTimeout.unregister(this);
                    this.clearHandler(null, useDispatch);
                    if (this.close) {
                        this.close();
                    }
                }
                break;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.wsWriteTimeout.unregister(this);
            this.clearHandler(e, useDispatch);
            this.close();
        }
        if (!complete && (timeout = this.getSendTimeout()) > 0L) {
            this.timeoutExpiry = timeout + System.currentTimeMillis();
            this.wsWriteTimeout.register(this);
        }
    }

    protected void doClose() {
        if (this.handler != null) {
            this.clearHandler(new EOFException(), true);
        }
        this.socketWrapper.close();
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean useDispatch) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), useDispatch);
        }
        this.close();
    }

    protected void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    private void clearHandler(Throwable t, boolean useDispatch) {
        SendHandler sh = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sh != null) {
            if (useDispatch) {
                OnResultRunnable r = new OnResultRunnable(sh, t);
                AbstractEndpoint endpoint = this.socketWrapper.getEndpoint();
                Executor containerExecutor = endpoint.getExecutor();
                if (endpoint.isRunning() && containerExecutor != null) {
                    containerExecutor.execute(r);
                } else {
                    r.run();
                }
            } else if (t == null) {
                sh.onResult(new SendResult());
            } else {
                sh.onResult(new SendResult(t));
            }
        }
    }

    private static class OnResultRunnable
    implements Runnable {
        private final SendHandler sh;
        private final Throwable t;

        private OnResultRunnable(SendHandler sh, Throwable t) {
            this.sh = sh;
            this.t = t;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
        }
    }
}

