/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.management.openmbean.CompositeData;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IContext;
import org.red5.server.api.IMappingStrategy;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.scope.IScopeResolver;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ScopeHandlerNotFoundException;
import org.red5.server.jmx.mxbeans.ContextMXBean;
import org.red5.server.service.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public class Context
implements IContext,
ApplicationContextAware,
ContextMXBean {
    public static final Logger logger = LoggerFactory.getLogger(Context.class);
    private ApplicationContext applicationContext;
    private BeanFactory coreContext;
    private String contextPath = "";
    private IScopeResolver scopeResolver;
    private IClientRegistry clientRegistry;
    private IServiceInvoker serviceInvoker;
    private IMappingStrategy mappingStrategy;
    private IPersistenceStore persistanceStore;

    @ConstructorProperties(value={""})
    public Context() {
    }

    @ConstructorProperties(value={"context", "contextPath"})
    public Context(ApplicationContext context, String contextPath) {
        this.setApplicationContext(context);
        this.contextPath = contextPath;
    }

    public IGlobalScope getGlobalScope() {
        IGlobalScope gs = this.scopeResolver.getGlobalScope();
        logger.trace("Global scope: {}", (Object)gs);
        return gs;
    }

    public IScopeResolver getScopeResolver() {
        return this.scopeResolver;
    }

    @Override
    public IScope resolveScope(String path) {
        return this.scopeResolver.resolveScope(path);
    }

    @Override
    public IScope resolveScope(IScope root, String path) {
        return this.scopeResolver.resolveScope(root, path);
    }

    public void setClientRegistry(IClientRegistry clientRegistry) {
        this.clientRegistry = clientRegistry;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public void setScopeResolver(IScopeResolver scopeResolver) {
        this.scopeResolver = scopeResolver;
    }

    public void setServiceInvoker(IServiceInvoker serviceInvoker) {
        this.serviceInvoker = serviceInvoker;
    }

    @Override
    public IPersistenceStore getPersistanceStore() {
        return this.persistanceStore;
    }

    public void setPersistanceStore(IPersistenceStore persistanceStore) {
        this.persistanceStore = persistanceStore;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
        String deploymentType = System.getProperty("red5.deployment.type");
        logger.debug("Deployment type: " + deploymentType);
        if (deploymentType == null) {
            String config = System.getProperty("red5.conf_file");
            if (config == null) {
                config = "red5.xml";
            }
            this.coreContext = (BeanFactory)new ClassPathXmlApplicationContext(config).getBean("red5.core");
        } else {
            logger.info("Setting parent bean factory as core");
            this.coreContext = this.applicationContext.getParentBeanFactory();
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setContextPath(String contextPath) {
        if (!contextPath.endsWith("/")) {
            contextPath = String.valueOf(contextPath) + '/';
        }
        this.contextPath = contextPath;
    }

    @Override
    public IClientRegistry getClientRegistry() {
        return this.clientRegistry;
    }

    @Override
    public IScope getScope() {
        return null;
    }

    @Override
    public IServiceInvoker getServiceInvoker() {
        return this.serviceInvoker;
    }

    @Override
    public Object lookupService(String serviceName) {
        serviceName = this.getMappingStrategy().mapServiceName(serviceName);
        try {
            Object bean = this.applicationContext.getBean(serviceName);
            if (bean != null) {
                return bean;
            }
            throw new ServiceNotFoundException(serviceName);
        }
        catch (NoSuchBeanDefinitionException err) {
            throw new ServiceNotFoundException(serviceName);
        }
    }

    @Override
    public IScopeHandler lookupScopeHandler(String contextPath) {
        String scopeHandlerName = this.getMappingStrategy().mapScopeHandlerName(contextPath);
        Object bean = this.applicationContext.getBean(scopeHandlerName);
        if (bean != null && bean instanceof IScopeHandler) {
            return (IScopeHandler)bean;
        }
        throw new ScopeHandlerNotFoundException(scopeHandlerName);
    }

    @Override
    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public Resource[] getResources(String pattern) throws IOException {
        return this.applicationContext.getResources(String.valueOf(this.contextPath) + pattern);
    }

    @Override
    public Resource getResource(String path) {
        return this.applicationContext.getResource(String.valueOf(this.contextPath) + path);
    }

    @Override
    public IScope resolveScope(String host, String path) {
        return this.scopeResolver.resolveScope(path);
    }

    public boolean hasBean(String beanId) {
        return this.applicationContext.containsBean(beanId);
    }

    @Override
    public Object getBean(String beanId) {
        Object bean = null;
        try {
            bean = this.applicationContext.getBean(beanId);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("Bean lookup failed for {} in the application context", (Object)beanId, (Object)e);
        }
        if (bean == null) {
            bean = this.getCoreService(beanId);
        }
        return bean;
    }

    @Override
    public Object getCoreService(String beanId) {
        return this.coreContext.getBean(beanId);
    }

    public void setCoreBeanFactory(BeanFactory core) {
        this.coreContext = core;
    }

    public ClassLoader getClassLoader() {
        return this.applicationContext.getClassLoader();
    }

    public static Context from(CompositeData cd) {
        Context instance = new Context();
        if (cd.containsKey("context") && cd.containsKey("contextPath")) {
            Object context = cd.get("context");
            Object contextPath = cd.get("contextPath");
            if (context != null && contextPath != null) {
                instance = new Context((ApplicationContext)context, (String)contextPath);
            }
        }
        return instance;
    }
}

