/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.AttributeStore;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;

public class PersistableAttributeStore
extends AttributeStore
implements IPersistable {
    protected boolean persistent = true;
    protected String name;
    protected String type;
    protected String path;
    protected long lastModified = -1L;
    protected IPersistenceStore store;

    public PersistableAttributeStore(String type, String name, String path, boolean persistent) {
        this.type = type;
        this.name = name;
        this.path = path;
        this.persistent = persistent;
    }

    protected void modified() {
        this.lastModified = System.currentTimeMillis();
        if (this.store != null) {
            this.store.save((IPersistable)this);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void serialize(Output output) throws IOException {
        HashMap persistentAttributes = new HashMap();
        for (Map.Entry entry : this.getAttributes().entrySet()) {
            String name = (String)entry.getKey();
            if (name.startsWith("_transient")) continue;
            persistentAttributes.put(name, entry.getValue());
        }
        Serializer.serialize((Output)output, persistentAttributes);
    }

    public void deserialize(Input input) throws IOException {
        this.setAttributes((Map)Deserializer.deserialize((Input)input, Map.class));
    }

    public void setStore(IPersistenceStore store) {
        if (this.store != null) {
            this.store.notifyClose();
        }
        this.store = store;
        if (store != null) {
            store.load((IPersistable)this);
        }
    }

    public IPersistenceStore getStore() {
        return this.store;
    }

    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        if (defaultValue == null) {
            throw new NullPointerException("the default value may not be null");
        }
        Object result = this.attributes.putIfAbsent(name, defaultValue);
        if (result == null) {
            this.modified();
            result = defaultValue;
        }
        return result;
    }

    public boolean setAttribute(String name, Object value) {
        boolean result = super.setAttribute(name, value);
        if (result && name != null && !name.startsWith("_transient")) {
            this.modified();
        }
        return result;
    }

    public boolean setAttributes(Map<String, Object> values) {
        boolean success = super.setAttributes(values);
        this.modified();
        return success;
    }

    public boolean setAttributes(IAttributeStore values) {
        boolean success = super.setAttributes(values);
        this.modified();
        return success;
    }

    public boolean removeAttribute(String name) {
        boolean result = super.removeAttribute(name);
        if (result && name != null && !name.startsWith("_transient")) {
            this.modified();
        }
        return result;
    }

    public void removeAttributes() {
        super.removeAttributes();
        this.modified();
    }
}

