/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.object.Output;
import org.red5.server.api.IContext;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.net.servlet.ServletUtils;
import org.red5.server.persistence.RamPersistence;
import org.red5.server.so.SharedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResource;

public class FilePersistence
extends RamPersistence {
    private Logger log = LoggerFactory.getLogger(FilePersistence.class);
    private ISchedulingService schedulingService;
    private ConcurrentLinkedQueue<IPersistable> queue = new ConcurrentLinkedQueue();
    private String path = "persistence";
    private String rootDir = "";
    private String extension = ".red5";
    private boolean checkForEmptyDirectories = true;
    private int persistenceInterval = 10000;
    private String storeJobName;

    public FilePersistence(ResourcePatternResolver resolver) {
        super(resolver);
        this.setPath(this.path);
    }

    public FilePersistence(IScope scope) {
        super(scope);
        this.setPath(this.path);
        IContext ctx = scope.getContext();
        this.schedulingService = ctx.hasBean("schedulingService") ? (ISchedulingService)ctx.getBean("schedulingService") : (ISchedulingService)scope.getParent().getContext().getBean("schedulingService");
        this.storeJobName = this.schedulingService.addScheduledJob(this.persistenceInterval, (IScheduledJob)new FilePersistenceJob());
    }

    private String getContextPath(Resource rootFile) {
        String contextPath = null;
        if (rootFile instanceof ServletContextResource) {
            ServletContextResource servletResource = (ServletContextResource)rootFile;
            contextPath = servletResource.getServletContext().getContextPath();
            if ("/".equals(contextPath)) {
                contextPath = "/root";
            }
        } else if (this.resources instanceof IScope && (contextPath = ((IScope)this.resources).getContextPath()) == null) {
            contextPath = "/root";
        }
        this.log.debug("Persistence context path: {}", (Object)contextPath);
        return contextPath;
    }

    private void initRootDir(Resource rootFile, String contextPath) throws IOException {
        if (rootFile instanceof ServletContextResource) {
            this.rootDir = String.format("%s/webapps%s", System.getProperty("red5.root"), contextPath);
        } else if (this.resources instanceof IScope) {
            this.rootDir = String.format("%s%s", this.resources.getResource("/").getFile().getAbsolutePath(), contextPath);
        }
        this.log.debug("Persistence directory path: {}", (Object)this.rootDir);
        File persistDir = new File(this.rootDir, this.path);
        if (!persistDir.exists()) {
            if (!persistDir.mkdirs()) {
                this.log.warn("Persistence directory creation failed");
            } else {
                this.log.debug("Persistence directory access - read: {} write: {}", (Object)persistDir.canRead(), (Object)persistDir.canWrite());
            }
        } else {
            this.log.debug("Persistence directory access - read: {} write: {}", (Object)persistDir.canRead(), (Object)persistDir.canWrite());
        }
        persistDir = null;
    }

    public void setPath(String path) {
        this.log.debug("Set path: {}", (Object)path);
        Resource rootFile = this.resources.getResource(path);
        try {
            this.log.debug("Absolute path: {}", (Object)this.resources.getResource("/").getFile().getAbsolutePath());
            if (!rootFile.exists()) {
                this.log.debug("Persistence directory does not exist");
                String contextPath = this.getContextPath(rootFile);
                this.initRootDir(rootFile, contextPath);
            } else {
                this.rootDir = rootFile.getFile().getAbsolutePath();
            }
            this.log.debug("Root dir: {} path: {}", (Object)this.rootDir, (Object)path);
            this.path = path;
        }
        catch (IOException err) {
            this.log.error("I/O exception thrown when setting file path to {}", (Object)path, (Object)err);
            throw new RuntimeException(err);
        }
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setCheckForEmptyDirectories(boolean checkForEmptyDirectories) {
        this.checkForEmptyDirectories = checkForEmptyDirectories;
    }

    public int getPersistenceInterval() {
        return this.persistenceInterval;
    }

    public void setPersistenceInterval(int persistenceInterval) {
        this.persistenceInterval = persistenceInterval;
    }

    private String getObjectFilepath(IPersistable object) {
        return this.getObjectFilepath(object, false);
    }

    private String getObjectFilepath(IPersistable object, boolean completePath) {
        StringBuilder result = new StringBuilder(this.path);
        result.append('/');
        result.append(object.getType());
        result.append('/');
        String objectPath = object.getPath();
        this.log.debug("Object path: {}", (Object)objectPath);
        result.append(objectPath);
        if (!objectPath.endsWith("/")) {
            result.append('/');
        }
        if (completePath) {
            String name = object.getName();
            this.log.debug("Object name: {}", (Object)name);
            int pos = name.lastIndexOf(47);
            if (pos >= 0) {
                result.append(name.substring(0, pos));
            }
        }
        int idx = -1;
        if (File.separatorChar != '/') {
            while ((idx = result.indexOf(File.separator)) != -1) {
                result.deleteCharAt(idx);
                result.insert(idx, '/');
            }
        }
        if ((idx = result.indexOf("./")) != -1) {
            result.delete(idx, idx + 2);
        }
        while ((idx = result.indexOf("//")) != -1) {
            result.deleteCharAt(idx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adjusted object path: {}", (Object)result.toString());
        }
        return result.toString();
    }

    protected String getObjectPath(String id, String name) {
        if (id.startsWith(this.path)) {
            id = id.substring(this.path.length() + 1);
        }
        return super.getObjectPath(id, name);
    }

    private String getObjectFilename(IPersistable object) {
        String path = this.getObjectFilepath(object);
        String name = object.getName();
        if (name == null) {
            name = "__null__";
        }
        return String.valueOf(path) + name + this.extension;
    }

    private IPersistable doLoad(String name) {
        return this.doLoad(name, null);
    }

    /*
     * Exception decompiling
     */
    private IPersistable doLoad(String name, IPersistable object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IPersistable load(String name) {
        this.log.debug("load - name: {}", (Object)name);
        IPersistable result = super.load(name);
        if (result != null) {
            return result;
        }
        return this.doLoad(String.valueOf(this.path) + '/' + name + this.extension);
    }

    public boolean load(IPersistable object) {
        this.log.debug("load - name: {}", (Object)object);
        if (object.isPersistent()) {
            return true;
        }
        return this.doLoad(this.getObjectFilename(object), object) != null;
    }

    protected boolean saveObject(IPersistable object) {
        this.log.debug("saveObject - object: {}", (Object)object);
        boolean result = true;
        String path = this.getObjectFilepath(object, true);
        this.log.trace("Path: {}", (Object)path);
        Resource resPath = this.resources.getResource(path);
        boolean exists = resPath.exists();
        this.log.debug("Resource (relative dir) exists: {}", (Object)exists);
        File dir = null;
        try {
            if (!exists) {
                resPath = this.resources.getResource("classpath:" + path);
                exists = resPath.exists();
                this.log.debug("Resource (classpath dir) exists: {}", (Object)exists);
                if (!exists) {
                    StringBuilder root = new StringBuilder(this.rootDir);
                    int idx = -1;
                    if (File.separatorChar != '/') {
                        while ((idx = root.indexOf(File.separator)) != -1) {
                            root.deleteCharAt(idx);
                            root.insert(idx, '/');
                        }
                    }
                    resPath = this.resources.getResource("file://" + root.toString() + File.separatorChar + path);
                    exists = resPath.exists();
                    this.log.debug("Resource (absolute dir) exists: {}", (Object)exists);
                }
            }
            dir = resPath.getFile();
            this.log.debug("Resulting absolute path: {}", (Object)dir.getAbsolutePath());
            if (!dir.isDirectory() && !dir.mkdirs()) {
                this.log.error("Could not create directory {}", (Object)dir.getAbsolutePath());
                result = false;
            }
        }
        catch (IOException err) {
            this.log.error("Could not create resource file for path {}", (Object)path, (Object)err);
            result = false;
        }
        if (result) {
            SharedObject soRef;
            if (object instanceof SharedObject && (soRef = (SharedObject)object).getAttributes().size() == 0) {
                return true;
            }
            String filename = this.getObjectFilename(object);
            this.log.debug("File name: {}", (Object)filename);
            if (filename.indexOf(47) != -1) {
                filename = filename.substring(filename.lastIndexOf(47));
                this.log.debug("New file name: {}", (Object)filename);
            }
            File file = new File(dir, filename);
            IoBuffer buf = null;
            try {
                try {
                    int initialSize = 8192;
                    if (file.exists()) {
                        initialSize += (int)file.length();
                    }
                    buf = IoBuffer.allocate((int)initialSize);
                    buf.setAutoExpand(true);
                    org.red5.io.amf.Output out = new org.red5.io.amf.Output(buf);
                    out.writeString(object.getClass().getName());
                    object.serialize((Output)out);
                    buf.flip();
                    FileOutputStream output = new FileOutputStream(file.getAbsolutePath());
                    ServletUtils.copy((InputStream)buf.asInputStream(), (OutputStream)output);
                    output.close();
                    this.log.debug("Stored persistent object {} at {}", (Object)object, (Object)filename);
                }
                catch (IOException e) {
                    this.log.error("Could not create / write file {}", (Object)filename, (Object)e);
                    this.log.warn("Exception {}", (Throwable)e);
                    result = false;
                    if (buf != null) {
                        buf.free();
                        buf = null;
                    }
                    file = null;
                    dir = null;
                }
            }
            finally {
                if (buf != null) {
                    buf.free();
                    buf = null;
                }
                file = null;
                dir = null;
            }
        }
        return result;
    }

    public boolean save(IPersistable object) {
        if (super.save(object)) {
            return this.queue.add(object);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void checkRemoveEmptyDirectories(String base) {
        block3: {
            if (!this.checkForEmptyDirectories) break block3;
            resFile = this.resources.getResource(base.substring(0, base.lastIndexOf(47)));
            try {
                dir = resFile.getFile().getAbsolutePath();
                ** GOTO lbl10
            }
            catch (IOException err) {
                return;
            }
            while ((fp = new File(dir)).isDirectory() && fp.list().length == 0 && fp.delete()) {
                dir = fp.getParent();
lbl10:
                // 2 sources

                if (!dir.equals(this.rootDir)) continue;
            }
        }
    }

    public boolean remove(String name) {
        super.remove(name);
        boolean result = true;
        String filename = String.valueOf(this.path) + '/' + name + this.extension;
        Resource resFile = this.resources.getResource(filename);
        if (resFile.exists()) {
            try {
                result = resFile.getFile().delete();
                if (result) {
                    this.checkRemoveEmptyDirectories(filename);
                }
            }
            catch (IOException err) {
                result = false;
            }
        }
        return result;
    }

    public boolean remove(IPersistable object) {
        return this.remove(this.getObjectId(object));
    }

    public void notifyClose() {
        if (this.storeJobName != null) {
            this.schedulingService.removeScheduledJob(this.storeJobName);
            this.storeJobName = null;
        }
        this.persist();
        super.notifyClose();
    }

    private void persist() {
        IPersistable persistable = null;
        while (!this.queue.isEmpty()) {
            try {
                persistable = this.queue.poll();
                if (this.saveObject(persistable)) continue;
                this.log.warn("Object persist failed for: {}", (Object)persistable);
            }
            catch (Throwable e) {
                this.log.error("Error while saving {} in {}. {}", new Object[]{persistable, this, e});
            }
        }
    }

    private final class FilePersistenceJob
    implements IScheduledJob {
        private FilePersistenceJob() {
        }

        public void execute(ISchedulingService svc) {
            FilePersistence.this.persist();
        }
    }
}

