/*
 * Decompiled with CFR 0.152.
 */
package org.red5.spring;

import java.beans.PropertyEditorSupport;
import java.net.InetAddress;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddressEditor
extends PropertyEditorSupport {
    private static Logger log = LoggerFactory.getLogger(InetAddressEditor.class);
    private static Pattern ipv4 = Pattern.compile("(([01][0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([01][0-9][0-9]|2[0-4][0-9]|25[0-5])");
    private static Pattern ipv6 = Pattern.compile("([0-9a-fA-F]{4}:){7}[0-9a-fA-F]{4}");

    @Override
    public void setAsText(String textValue) {
        log.trace("setAsText: {}", (Object)textValue);
        InetAddress address = null;
        try {
            if (ipv4.matcher(textValue).matches()) {
                String[] addressParts = textValue.split("\\.");
                assert (addressParts.length == 4);
                byte[] addressBytes = new byte[addressParts.length];
                int i = 0;
                while (i < addressParts.length) {
                    addressBytes[i] = (byte)Short.parseShort(addressParts[i]);
                    ++i;
                }
                address = InetAddress.getByAddress(addressBytes);
            } else if (ipv6.matcher(textValue).matches()) {
                String[] addressParts = textValue.split(":");
                assert (addressParts.length == 8);
                byte[] addressBytes = new byte[addressParts.length * 2];
                int i = 0;
                while (i < addressParts.length) {
                    addressBytes[i * 2] = Byte.parseByte(addressParts[i].substring(0, 2));
                    addressBytes[i * 2 + 1] = Byte.parseByte(addressParts[i].substring(2, 4));
                    ++i;
                }
                address = InetAddress.getByAddress(addressBytes);
            } else {
                address = InetAddress.getByName(textValue);
            }
        }
        catch (Exception ex) {
            log.error("Exception setting address: {}", (Object)textValue, (Object)ex);
            throw new IllegalArgumentException(ex);
        }
        this.setValue(address);
    }

    @Override
    public String getAsText() {
        return ((InetAddress)this.getValue()).getHostAddress();
    }
}

