/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.plugin.PluginRegistry;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketScope
implements InitializingBean,
DisposableBean {
    private static Logger log = LoggerFactory.getLogger(WebSocketScope.class);
    private WebSocketScopeManager manager;
    protected ConcurrentSkipListSet<WebSocketConnection> conns = new ConcurrentSkipListSet();
    protected CopyOnWriteArraySet<IWebSocketDataListener> listeners = new CopyOnWriteArraySet();
    protected IScope scope;
    protected String path = "default";

    public WebSocketScope() {
    }

    public WebSocketScope(IScope scope) {
        log.debug("Creating WebSocket scope for: {}", (Object)scope);
        this.setScope(scope);
        this.setPath(String.format("/%s", scope.getName()));
    }

    public void afterPropertiesSet() throws Exception {
        this.register();
    }

    public void destroy() throws Exception {
        this.unregister();
    }

    public void register() {
        log.info("Application scope: {}", (Object)this.scope);
        this.manager = ((WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin")).getManager(this.scope);
        if (this.manager.setApplication(this.scope)) {
            log.info("WebSocket app added: {}", (Object)this.scope.getName());
        }
        if (this.manager.addWebSocketScope(this)) {
            log.info("WebSocket scope added");
        }
    }

    public void unregister() {
        if (ScopeUtils.isApp((IBasicScope)this.scope)) {
            this.manager.removeApplication(this.scope);
        }
        this.manager.removeWebSocketScope(this);
        this.conns.forEach(conn -> {
            if (this.conns.remove(conn)) {
                conn.close();
            }
        });
        this.listeners.forEach(listener -> {
            if (this.listeners.remove(listener)) {
                listener.stop();
            }
        });
    }

    public WebSocketConnection getConnectionBySessionId(String id) {
        log.debug("getConnectionBySessionId: {}", (Object)id);
        Optional<WebSocketConnection> opt = this.conns.stream().filter(conn -> id.equals(conn.getSessionId())).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    public WebSocketScopeManager getManager() {
        return this.manager;
    }

    public Set<WebSocketConnection> getConns() {
        return this.conns;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
        this.scope.setAttribute("ws.scope", (Object)this);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void addConnection(WebSocketConnection conn) {
        if (this.conns.add(conn)) {
            log.debug("Added connection: {}", (Object)conn);
            this.listeners.forEach(listener -> listener.onWSConnect(conn));
        } else {
            log.debug("Add connection skipped, already registered: {}", (Object)conn);
        }
    }

    public void removeConnection(WebSocketConnection conn) {
        if (this.conns.remove(conn)) {
            log.debug("Removed connection: {}", (Object)conn);
            this.listeners.forEach(listener -> listener.onWSDisconnect(conn));
        } else {
            log.debug("Remove connection skipped, not registered: {}", (Object)conn);
        }
    }

    public void addListener(IWebSocketDataListener listener) {
        log.debug("addListener to {}: {}", (Object)this.path, (Object)listener);
        this.listeners.add(listener);
    }

    public void removeListener(IWebSocketDataListener listener) {
        log.debug("removeListener from {}: {}", (Object)this.path, (Object)listener);
        this.listeners.remove(listener);
    }

    public void setListeners(Collection<IWebSocketDataListener> listeners) {
        log.trace("setListeners on {}: {}", (Object)this.path, listeners);
        this.listeners.addAll(listeners);
    }

    public Set<IWebSocketDataListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public boolean hasListener(Class<?> clazz) {
        return this.listeners.stream().filter(listener -> listener.getClass().isInstance(clazz)).findFirst().isPresent();
    }

    public boolean isValid() {
        return this.conns.size() + this.listeners.size() > 0;
    }

    public void onMessage(WSMessage message) {
        log.trace("Listeners: {}", (Object)this.listeners.size());
        this.listeners.forEach(listener -> {
            try {
                listener.onWSMessage(message);
            }
            catch (Exception e) {
                log.warn("onMessage exception", (Throwable)e);
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketScope other = (WebSocketScope)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "WebSocketScope [path=" + this.path + ", listeners=" + this.listeners.size() + ", connections=" + this.conns.size() + "]";
    }
}

