/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.server.DefaultWsServerContainer;
import org.red5.net.websocket.server.UpgradeUtil;
import org.red5.net.websocket.server.WsMappingResult;
import org.red5.server.adapter.StatefulScopeWrappingAdapter;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class WsFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(WsFilter.class);
    private DefaultWsServerContainer sc;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext ctx = filterConfig.getServletContext();
        this.sc = (DefaultWsServerContainer)((Object)ctx.getAttribute("javax.websocket.server.ServerContainer"));
        if (this.sc == null) {
            this.sc = (DefaultWsServerContainer)WebSocketPlugin.getWsServerContainerInstance(ctx);
        }
        this.log.debug("init completed - sc: {}", (Object)this.sc);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contextPath = request.getServletContext().getContextPath();
        this.log.debug("doFilter: {} endpoints registered: {}", (Object)contextPath, (Object)this.sc.areEndpointsRegistered());
        if (!this.sc.areEndpointsRegistered() || !UpgradeUtil.isWebSocketUpgradeRequest(request, response)) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationContext appCtx = (ApplicationContext)request.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appCtx != null) {
            StatefulScopeWrappingAdapter app = (StatefulScopeWrappingAdapter)appCtx.getBean("web.handler");
            IScope appScope = app.getScope();
            this.log.debug("Application scope: {} ws scope: {}", (Object)appScope.getName(), appScope.getAttribute("ws.scope"));
        } else {
            this.log.warn("Application context was not found in the servlet context for {}", (Object)contextPath);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestUri = req.getRequestURI();
        String queryString = req.getQueryString();
        String pathInfo = req.getPathInfo();
        this.log.debug("Request uri: {} path info: {} query string: {}", new Object[]{requestUri, pathInfo, queryString});
        WsMappingResult mappingResult = this.sc.findMapping(contextPath);
        this.log.debug("WsMappingResult: {} for contextPath: {}", (Object)mappingResult, (Object)contextPath);
        if (mappingResult == null) {
            chain.doFilter(request, response);
            return;
        }
        UpgradeUtil.doUpgrade(this.sc, req, resp, mappingResult.getConfig(), mappingResult.getPathParams());
    }

    public void destroy() {
    }
}

