/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.WebConnection;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.server.DefaultWsServerContainer;
import org.red5.net.websocket.server.WsFrameServer;
import org.red5.net.websocket.server.WsHandshakeRequest;
import org.red5.net.websocket.server.WsRemoteEndpointImplServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsHttpUpgradeHandler
implements InternalHttpUpgradeHandler {
    private Logger log = LoggerFactory.getLogger(WsHttpUpgradeHandler.class);
    private final boolean isDebug = this.log.isDebugEnabled();
    private static final StringManager sm = StringManager.getManager(WsHttpUpgradeHandler.class);
    private final ClassLoader applicationClassLoader;
    private SocketWrapperBase<?> socketWrapper;
    private UpgradeInfo upgradeInfo = new UpgradeInfo();
    private Endpoint ep;
    private ServerEndpointConfig endpointConfig;
    private DefaultWsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private List<Extension> negotiatedExtensions;
    private String subProtocol;
    private Transformation transformation;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsRemoteEndpointImplServer wsRemoteEndpointServer;
    private WsFrameServer wsFrame;
    private WsSession wsSession;

    public WsHttpUpgradeHandler() {
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setSocketWrapper(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public void preInit(Endpoint ep, EndpointConfig endpointConfig, DefaultWsServerContainer wsc, WsHandshakeRequest handshakeRequest, List<Extension> negotiatedExtensionsPhase2, String subProtocol, Transformation transformation, Map<String, String> pathParameters, boolean secure) {
        this.ep = ep;
        this.endpointConfig = (ServerEndpointConfig)endpointConfig;
        this.webSocketContainer = wsc;
        this.handshakeRequest = handshakeRequest;
        this.negotiatedExtensions = negotiatedExtensionsPhase2;
        this.subProtocol = subProtocol;
        this.transformation = transformation;
        this.pathParameters = pathParameters;
        this.secure = secure;
        String httpSessionId = null;
        Object session = handshakeRequest.getHttpSession();
        if (session != null) {
            httpSessionId = ((HttpSession)session).getId();
            this.log.debug("pre-init with http session id: {}", (Object)httpSessionId);
        } else {
            this.log.debug("pre-init without http session");
        }
    }

    public void init(WebConnection connection) {
        if (this.ep == null) {
            throw new IllegalStateException(sm.getString("wsHttpUpgradeHandler.noPreInit"));
        }
        String httpSessionId = null;
        Object session = this.handshakeRequest.getHttpSession();
        if (session != null) {
            httpSessionId = ((HttpSession)session).getId();
            this.log.debug("init with http session id: {}", (Object)httpSessionId);
        } else {
            this.log.debug("init without http session");
        }
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.wsRemoteEndpointServer = new WsRemoteEndpointImplServer(this.socketWrapper, this.upgradeInfo);
            if (this.isDebug) {
                this.log.debug("New connection 1 {}", (Object)this.wsRemoteEndpointServer);
            }
            if (this.isDebug) {
                this.log.debug("WS session pre-ctor - wsRemoteEndpointServer: {}, webSocketContainer: {}, handshakeRequest.getRequestURI: {}, handshakeRequest.getParameterMap: {}, handshakeRequest.getQueryString: {}, handshakeRequest.getUserPrincipal: {}, httpSessionId: {}, negotiatedExtensions: {}, subProtocol: {}, pathParameters: {}, secure: {}, endpointConfig: {}", new Object[]{this.wsRemoteEndpointServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), httpSessionId, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, this.endpointConfig});
            }
            this.wsSession = new WsSession(this.ep, (WsRemoteEndpointImplBase)this.wsRemoteEndpointServer, (WsWebSocketContainer)this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), httpSessionId, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, (EndpointConfig)this.endpointConfig);
            if (this.isDebug) {
                this.log.debug("New connection 2 {}", (Object)this.wsSession);
            }
            this.wsFrame = new WsFrameServer(this.socketWrapper, this.upgradeInfo, this.wsSession, this.transformation, this.applicationClassLoader);
            if (this.isDebug) {
                this.log.debug("New connection 3 {}", (Object)this.wsFrame);
            }
            this.wsRemoteEndpointServer.setTransformation(this.wsFrame.getTransformation());
            if (this.isDebug) {
                this.log.debug("New connection 4");
            }
            WebSocketScopeManager manager = (WebSocketScopeManager)this.endpointConfig.getUserProperties().get("ws.manager");
            if (this.isDebug) {
                this.log.debug("New connection 5");
            }
            WebSocketScope scope = (WebSocketScope)this.endpointConfig.getUserProperties().get("ws.scope");
            if (this.isDebug) {
                this.log.debug("New connection 6 - Scope: {} WS session: {}", (Object)scope, (Object)this.wsSession);
            }
            WebSocketConnection conn = new WebSocketConnection(scope, (Session)this.wsSession);
            if (this.isDebug) {
                this.log.debug("New connection 7: {}", (Object)conn);
            }
            conn.setAttribute("remote.ip", this.socketWrapper.getRemoteAddr());
            conn.setAttribute("remote.port", this.socketWrapper.getRemotePort());
            conn.setHeaders(this.handshakeRequest.getHeaders());
            if (this.isDebug) {
                this.log.debug("New connection 8: {}", (Object)conn);
            }
            this.endpointConfig.getUserProperties().put("ws.connection", conn);
            this.wsSession.getUserProperties().put("ws.connection", conn);
            conn.setConnected();
            this.ep.onOpen((Session)this.wsSession, (EndpointConfig)this.endpointConfig);
            if (this.isDebug) {
                this.log.debug("New connection 9: endpoint opened");
            }
            String path = this.endpointConfig.getPath();
            this.webSocketContainer.registerSession(path, this.wsSession);
            if (this.isDebug) {
                this.log.debug("New connection 10: session registered");
            }
            manager.addConnection(conn);
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent status) {
        switch (status) {
            case OPEN_READ: {
                try {
                    return this.wsFrame.notifyDataAvailable();
                }
                catch (WsIOException ws) {
                    this.close(ws.getCloseReason());
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                }
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            case OPEN_WRITE: {
                this.wsRemoteEndpointServer.onWritePossible(false);
                break;
            }
            case STOP: {
                CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsHttpUpgradeHandler.serverStop"));
                try {
                    this.wsSession.close(cr);
                    break;
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                    return AbstractEndpoint.Handler.SocketState.CLOSED;
                }
            }
            case ERROR: {
                String msg = sm.getString("wsHttpUpgradeHandler.closeOnError");
                this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, msg), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, msg));
            }
            case CONNECT_FAIL: 
            case DISCONNECT: 
            case TIMEOUT: {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
        }
        if (this.wsFrame.isOpen()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADED;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    public void pause() {
    }

    public UpgradeInfo getUpgradeInfo() {
        return this.upgradeInfo;
    }

    public void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.error(sm.getString("wsHttpUpgradeHandler.destroyFailed"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError((Session)this.wsSession, throwable);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    private void close(CloseReason cr) {
        this.wsSession.onClose(cr);
    }

    public void setSslSupport(SSLSupport sslSupport) {
    }

    public void timeoutAsync(long now) {
        this.log.trace("timeoutAsync: {}", (Object)now);
    }
}

