/*
 * Decompiled with CFR 0.152.
 */
package org.red5.classloading;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.red5.classloading.ChildFirstClassLoader;

public final class ClassLoaderBuilder {
    public static final int USE_CLASSPATH_LIB = 1;
    public static final int USE_RED5_LIB = 2;
    public static final int USE_WAR_LIB = 3;

    public static ClassLoader build() {
        return ClassLoaderBuilder.build(null, 2, null);
    }

    public static ClassLoader build(Path path, int mode, ClassLoader parent) {
        final HashSet<URL> urlList = new HashSet<URL>();
        URLClassLoader loader = null;
        URL[] urls = null;
        if (mode == 2) {
            Path homeDir = null;
            String home = System.getProperty("red5.root", System.getenv("RED5_HOME"));
            if (home != null) {
                homeDir = Paths.get(home, new String[0]);
            } else {
                String classLocation = ClassLoaderBuilder.class.getProtectionDomain().getCodeSource().getLocation().toString();
                home = classLocation.substring(0, classLocation.lastIndexOf(47));
                homeDir = Paths.get(home, new String[0]);
            }
            try {
                Path red5jar = homeDir.resolve("red5-server.jar");
                if (!Files.exists(red5jar, new LinkOption[0])) {
                    System.out.println("Red5 server jar was not found, using fallback");
                    red5jar = homeDir.resolve("red5.jar");
                } else {
                    System.out.println("Red5 server jar was found");
                }
                urlList.add(red5jar.toUri().toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            System.out.printf("URL list: %s\n", urlList);
            Path libDir = null;
            String lib = System.getProperty("red5.lib_root");
            libDir = lib != null ? Paths.get(lib, new String[0]) : homeDir.resolve("lib");
            try {
                Files.walkFileTree(libDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toFile().getName().endsWith(".jar")) {
                            try {
                                urlList.add(file.toUri().toURL());
                            }
                            catch (MalformedURLException e) {
                                System.err.printf("Exception %s\n", e);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                System.err.printf("Exception %s\n", e);
            }
            ClassLoaderBuilder.scrubURLList(urlList);
            Path confDir = null;
            String conf = System.getProperty("red5.config_root");
            confDir = conf != null ? Paths.get(conf, new String[0]) : homeDir.resolve("conf");
            try {
                urlList.add(confDir.toUri().toURL());
            }
            catch (MalformedURLException e) {
                System.err.printf("Exception %s\n", e);
            }
            Object pluginsPath = System.getProperty("red5.plugins_root");
            if (pluginsPath == null) {
                pluginsPath = home + "/plugins";
                System.setProperty("red5.plugins_root", (String)pluginsPath);
            }
            try {
                Path pluginsDir = Files.createDirectories(Paths.get((String)pluginsPath, new String[0]), new FileAttribute[0]);
                urlList.add(pluginsDir.toUri().toURL());
                Files.walkFileTree(pluginsDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toFile().getName().endsWith(".jar")) {
                            try {
                                urlList.add(file.toUri().toURL());
                            }
                            catch (MalformedURLException e) {
                                System.err.printf("Exception %s\n", e);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                System.err.printf("Exception %s\n", e);
            }
            urls = urlList.toArray(new URL[0]);
            loader = parent == null ? new URLClassLoader(urls) : new URLClassLoader(urls, parent);
        } else {
            ArrayList<String> standardLibs = new ArrayList<String>(7);
            if (path != null) {
                try {
                    urlList.add(path.toUri().toURL());
                    URL classesURL = new URL("jar:file:" + path.toFile().getAbsolutePath().replace(File.separatorChar, '/') + "!/WEB-INF/classes/");
                    urlList.add(classesURL);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
            if (mode == 1) {
                String classPath = System.getProperty("java.class.path");
                StringTokenizer stClassPath = new StringTokenizer(classPath, File.pathSeparator);
                while (stClassPath.hasMoreTokens()) {
                    String nextPath = stClassPath.nextToken();
                    if (nextPath.toLowerCase().endsWith(".jar")) {
                        standardLibs.add(nextPath.substring(nextPath.lastIndexOf(File.separatorChar) + 1));
                    }
                    try {
                        urlList.add(Paths.get(nextPath, new String[0]).toUri().toURL());
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                }
            }
            if (mode == 3) {
                if (path.toFile().isDirectory()) {
                    Path libDir = path.resolve("WEB-INF").resolve("lib");
                    try {
                        Files.walkFileTree(libDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                if (file.toFile().getName().endsWith(".jar")) {
                                    try {
                                        urlList.add(file.toUri().toURL());
                                    }
                                    catch (MalformedURLException e) {
                                        System.err.printf("Exception %s\n", e);
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                } else {
                    try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                         JarInputStream jarStream = new JarInputStream(is);){
                        JarEntry entry = jarStream.getNextJarEntry();
                        while (entry != null) {
                            String entryName = entry.getName();
                            if (entryName.startsWith("WEB-INF/lib/") && entryName.endsWith(".jar") && !standardLibs.contains(entryName.substring(12))) {
                                Path tempJarFile = ClassLoaderBuilder.unpack(jarStream, entryName);
                                urlList.add(tempJarFile.toUri().toURL());
                            }
                            entry = jarStream.getNextJarEntry();
                        }
                        jarStream.close();
                    }
                    catch (IOException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                }
            }
            urls = urlList.toArray(new URL[0]);
            loader = new ChildFirstClassLoader(urls, parent);
        }
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    private static Path unpack(JarInputStream jarStream, String entryName) throws IOException {
        String libName = entryName.substring(entryName.lastIndexOf(47) + 1, entryName.length() - 4);
        Path tempJarFile = Files.createTempFile("tmp_" + libName, ".jar", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(tempJarFile, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = jarStream.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        return tempJarFile;
    }

    private static final void scrubURLList(Collection<URL> list) {
        URL[] urls;
        String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
        Pattern punct = Pattern.compile("\\p{Punct}");
        HashSet<URL> removalList = new HashSet<URL>(list.size());
        String topName = null;
        String checkName = null;
        block4: for (URL top : urls = list.toArray(new URL[0])) {
            if (removalList.contains(top)) continue;
            topName = ClassLoaderBuilder.parseUrl(top);
            if ("".equals(topName)) {
                removalList.add(top);
                continue;
            }
            if (topName.startsWith("red5")) continue;
            if (topName.endsWith("-")) {
                removalList.add(top);
                continue;
            }
            if (topName.startsWith("grobo") || topName.startsWith("junit") || topName.startsWith("ivy")) {
                removalList.add(top);
                continue;
            }
            if (topName.contains("javadoc") || topName.contains("sources")) {
                removalList.add(top);
                continue;
            }
            int topFirstDash = topName.indexOf(45);
            String prefix = topName.substring(0, topFirstDash != -1 ? topFirstDash : 3);
            int topSecondDash = topName.indexOf(45, topFirstDash + 1);
            for (URL check : list) {
                int checkVersionNumber;
                int topVersionNumber;
                String[] topVersion;
                String checkVers;
                String[] checkSubs;
                String[] topSubs;
                if (removalList.contains(check) || (checkName = ClassLoaderBuilder.parseUrl(check)).equals(topName) || checkName.endsWith("-") || !checkName.startsWith(prefix) || topSecondDash > 0 && (checkName.length() <= topSecondDash || checkName.charAt(topSecondDash) != '-' || !(topSubs = topName.split("-"))[1].equals((checkSubs = checkName.split("-"))[1]) || !Character.isDigit(topSubs[2].charAt(0)) && !Character.isDigit(checkSubs[2].charAt(0)) && !topSubs[2].equals(checkSubs[2])) || checkName.length() < topFirstDash + 1 || (checkVers = checkName.substring(topSecondDash != -1 ? topSecondDash + 1 : topFirstDash + 1)).startsWith("-")) continue;
                String topVers = topName.substring(topSecondDash != -1 ? topSecondDash + 1 : topFirstDash + 1);
                int topThirdDash = -1;
                String topThirdName = null;
                if (topVers.length() > 0 && !Character.isDigit(topVers.charAt(0))) {
                    topThirdDash = topVers.indexOf(45);
                    if (topThirdDash == -1) continue;
                    topThirdName = topVers.substring(0, topThirdDash);
                    topVers = topVers.substring(topThirdDash + 1);
                }
                int checkThirdDash = -1;
                String checkThirdName = null;
                if (!Character.isDigit(checkVers.charAt(0))) {
                    checkThirdDash = checkVers.indexOf(45);
                    if (checkThirdDash == -1) continue;
                    checkThirdName = checkVers.substring(0, checkThirdDash);
                    if (topThirdName == null || !topThirdName.equals(checkThirdName) || !Character.isDigit((checkVers = checkVers.substring(checkThirdDash + 1)).charAt(0))) continue;
                }
                if (topThirdName != null && checkThirdName == null || !(topVersion = punct.split(topVers))[0].matches("[\\d].*")) continue;
                if (topVersion.length > 2) {
                    char ch;
                    String v = topVersion[2].toLowerCase();
                    if (v.length() > 1) {
                        topVersion[2] = ClassLoaderBuilder.deleteAny(v, ALPHABET);
                    }
                    if (topVersion[2].length() == 1 && !Character.isDigit(ch = v.charAt(0))) {
                        topVersion[2] = "" + ALPHABET.indexOf(ch);
                    }
                }
                try {
                    topVersionNumber = topVersion.length == 1 ? Integer.valueOf(topVersion[0]).intValue() : Integer.valueOf(topVersion[0] + topVersion[1] + (Serializable)(topVersion.length > 2 ? topVersion[2] : Character.valueOf('0'))).intValue();
                }
                catch (NumberFormatException nfe) {
                    topVersionNumber = 0;
                    System.err.println("Error parsing topVers:" + topVers);
                }
                String[] checkVersion = punct.split(checkVers);
                if (checkVersion.length > 2) {
                    char ch;
                    String v = checkVersion[2].toLowerCase();
                    if (v.length() > 1) {
                        checkVersion[2] = ClassLoaderBuilder.deleteAny(v, ALPHABET);
                    }
                    if (checkVersion[2].length() == 1 && !Character.isDigit(ch = v.charAt(0))) {
                        checkVersion[2] = "" + ALPHABET.indexOf(ch);
                    }
                }
                try {
                    checkVersionNumber = checkVersion.length == 1 ? Integer.valueOf(checkVersion[0]).intValue() : Integer.valueOf(checkVersion[0] + checkVersion[1] + (Serializable)(checkVersion.length > 2 ? checkVersion[2] : Character.valueOf('0'))).intValue();
                }
                catch (NumberFormatException nfe) {
                    checkVersionNumber = 0;
                    System.err.println("Error parsing checkVers:" + checkVers);
                }
                if (topVersionNumber >= checkVersionNumber) {
                    removalList.add(check);
                    continue;
                }
                removalList.add(top);
                continue block4;
            }
        }
        list.removeAll(removalList);
    }

    private static String parseUrl(URL url) {
        String external = url.toExternalForm().toLowerCase();
        String[] parts = external.split("/");
        String libName = parts[parts.length - 1];
        libName = libName.substring(0, libName.length() - 4);
        return libName;
    }

    private static String deleteAny(String str, String removalChars) {
        String[] chars;
        StringBuilder sb = new StringBuilder(str);
        for (String c : chars = removalChars.split("")) {
            int index = -1;
            while ((index = sb.indexOf(c)) > 0) {
                sb.deleteCharAt(index);
            }
        }
        return sb.toString();
    }
}

