/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.redisson.api.HostPortNatMapper;
import org.redisson.api.NatMapper;
import org.redisson.config.BaseMasterSlaveServersConfig;

public class ClusterServersConfig
extends BaseMasterSlaveServersConfig<ClusterServersConfig> {
    private NatMapper natMapper = NatMapper.direct();
    private List<String> nodeAddresses = new ArrayList<String>();
    private int scanInterval = 5000;
    private boolean checkSlotsCoverage = true;

    public ClusterServersConfig() {
    }

    ClusterServersConfig(ClusterServersConfig config) {
        super(config);
        this.setNodeAddresses(config.getNodeAddresses());
        this.setScanInterval(config.getScanInterval());
        this.setNatMapper(config.getNatMapper());
        this.setCheckSlotsCoverage(config.isCheckSlotsCoverage());
    }

    public ClusterServersConfig addNodeAddress(String ... addresses) {
        this.nodeAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public List<String> getNodeAddresses() {
        return this.nodeAddresses;
    }

    void setNodeAddresses(List<String> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public ClusterServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    public boolean isCheckSlotsCoverage() {
        return this.checkSlotsCoverage;
    }

    public ClusterServersConfig setCheckSlotsCoverage(boolean checkSlotsCoverage) {
        this.checkSlotsCoverage = checkSlotsCoverage;
        return this;
    }

    @Deprecated
    public ClusterServersConfig setNatMap(Map<String, String> natMap) {
        HostPortNatMapper mapper = new HostPortNatMapper();
        mapper.setHostsPortMap(natMap);
        this.natMapper = mapper;
        return this;
    }

    public NatMapper getNatMapper() {
        return this.natMapper;
    }

    public ClusterServersConfig setNatMapper(NatMapper natMapper) {
        this.natMapper = natMapper;
        return this;
    }
}

