/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSemaphore {
    private final AtomicInteger counter;
    private final Queue<Entry> listeners = new ConcurrentLinkedQueue<Entry>();
    private final Set<Runnable> removedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public AsyncSemaphore(int permits) {
        this.counter = new AtomicInteger(permits);
    }

    public boolean tryAcquire(long timeoutMillis) {
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = () -> latch.countDown();
        this.acquire(runnable);
        try {
            boolean r = latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!r) {
                this.remove(runnable);
            }
            return r;
        }
        catch (InterruptedException e) {
            this.remove(runnable);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public int queueSize() {
        return this.listeners.size() - this.removedListeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
        this.removedListeners.clear();
    }

    public void acquire(Runnable listener) {
        this.acquire(listener, 1);
    }

    public void acquire(Runnable listener, int permits) {
        if (permits <= 0) {
            throw new IllegalArgumentException("permits should be non-zero");
        }
        this.listeners.add(new Entry(listener, permits));
        this.tryRun(1);
    }

    private void tryRun(int permits) {
        if (this.counter.get() == 0 || this.listeners.peek() == null) {
            return;
        }
        if (this.counter.addAndGet(-permits) >= 0) {
            Entry e = this.listeners.peek();
            if (e == null) {
                this.counter.addAndGet(permits);
                return;
            }
            if (e.getPermits() != permits) {
                this.counter.addAndGet(permits);
                this.tryRun(e.getPermits());
                return;
            }
            Entry entry = this.listeners.poll();
            if (entry == null) {
                this.counter.addAndGet(permits);
                return;
            }
            if (this.removedListeners.remove(entry.getRunnable())) {
                this.counter.addAndGet(entry.getPermits());
                this.tryRun(1);
            } else {
                entry.runnable.run();
            }
        } else {
            this.counter.addAndGet(permits);
        }
    }

    public void remove(Runnable listener) {
        this.removedListeners.add(listener);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryRun(1);
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }

    private static class Entry {
        private final Runnable runnable;
        private final int permits;

        Entry(Runnable runnable, int permits) {
            this.runnable = runnable;
            this.permits = permits;
        }

        public int getPermits() {
            return this.permits;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }
    }
}

