/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFailureHandling;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFilterTry<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelFilterTry(ParallelFlowable<T> source, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.predicate = predicate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelFilterConditionalSubscriber<T>((ConditionalSubscriber)a, this.predicate, this.errorHandler) : new ParallelFilterSubscriber<T>(a, this.predicate, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterConditionalSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final ConditionalSubscriber<? super T> downstream;

        ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b = this.predicate.test(t);
                    }
                    catch (Throwable ex) {
                        ParallelFailureHandling h;
                        Exceptions.throwIfFatal(ex);
                        try {
                            h = (ParallelFailureHandling)Objects.requireNonNull(this.errorHandler.apply(++retries, ex), "The errorHandler returned a null ParallelFailureHandling");
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancel();
                            this.onError(new CompositeException(ex, exc));
                            return false;
                        }
                        switch (h) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex);
                        return false;
                    }
                    break;
                }
                return b && this.downstream.tryOnNext(t);
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static final class ParallelFilterSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final Subscriber<? super T> downstream;

        ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b = this.predicate.test(t);
                    }
                    catch (Throwable ex) {
                        ParallelFailureHandling h;
                        Exceptions.throwIfFatal(ex);
                        try {
                            h = (ParallelFailureHandling)Objects.requireNonNull(this.errorHandler.apply(++retries, ex), "The errorHandler returned a null ParallelFailureHandling");
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancel();
                            this.onError(new CompositeException(ex, exc));
                            return false;
                        }
                        switch (h) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex);
                        return false;
                    }
                    break;
                }
                if (b) {
                    this.downstream.onNext(t);
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static abstract class BaseFilterSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Predicate<? super T> predicate;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        BaseFilterSubscriber(Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.predicate = predicate;
            this.errorHandler = errorHandler;
        }

        @Override
        public final void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public final void cancel() {
            this.upstream.cancel();
        }

        @Override
        public final void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.upstream.request(1L);
            }
        }
    }
}

