/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.api.listener.MessageListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.protocol.pubsub.PubSubType;

public class PubSubMessageListener<V>
implements RedisPubSubListener<Object> {
    private final MessageListener<V> listener;
    private final String name;
    private final Class<V> type;

    public String getName() {
        return this.name;
    }

    public PubSubMessageListener(Class<V> type, MessageListener<V> listener, String name) {
        this.type = type;
        this.listener = listener;
        this.name = name;
    }

    public MessageListener<V> getListener() {
        return this.listener;
    }

    @Override
    public void onMessage(CharSequence channel, Object message) {
        if (this.name.equals(channel.toString()) && this.type.isInstance(message)) {
            this.listener.onMessage(channel, message);
        }
    }

    @Override
    public void onPatternMessage(CharSequence pattern, CharSequence channel, Object message) {
        if (this.name.equals(pattern.toString()) && this.type.isInstance(message)) {
            this.listener.onMessage(channel, message);
        }
    }

    @Override
    public void onStatus(PubSubType type, CharSequence channel) {
    }
}

