/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import java.util.concurrent.atomic.AtomicLong;
import org.redisson.client.FailedNodeDetector;

public class FailedConnectionDetector
implements FailedNodeDetector {
    private long checkInterval;
    private final AtomicLong firstFailTime = new AtomicLong(0L);

    public FailedConnectionDetector() {
        this(180000L);
    }

    public FailedConnectionDetector(long checkInterval) {
        if (checkInterval == 0L) {
            throw new IllegalArgumentException("checkInterval value");
        }
        this.checkInterval = checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        if (checkInterval == 0L) {
            throw new IllegalArgumentException("checkInterval value");
        }
        this.checkInterval = checkInterval;
    }

    @Override
    public void onConnectFailed() {
    }

    @Override
    public void onConnectFailed(Throwable cause) {
        this.firstFailTime.compareAndSet(0L, System.currentTimeMillis());
    }

    @Override
    public void onConnectSuccessful() {
        this.firstFailTime.set(0L);
    }

    @Override
    public void onPingSuccessful() {
        this.firstFailTime.set(0L);
    }

    @Override
    public void onCommandSuccessful() {
    }

    @Override
    public void onPingFailed() {
    }

    @Override
    public void onPingFailed(Throwable cause) {
        this.firstFailTime.compareAndSet(0L, System.currentTimeMillis());
    }

    @Override
    public void onCommandFailed(Throwable cause) {
    }

    @Override
    public boolean isNodeFailed() {
        if (this.firstFailTime.get() != 0L && this.checkInterval > 0L) {
            return System.currentTimeMillis() - this.firstFailTime.get() > this.checkInterval;
        }
        return false;
    }
}

