/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.eviction.EvictionTask;
import org.redisson.misc.CompletableFutureWrapper;

public class MapCacheEvictionTask
extends EvictionTask {
    private final String name;
    private final String timeoutSetName;
    private final String maxIdleSetName;
    private final String expiredChannelName;
    private final String lastAccessTimeSetName;
    private final String executeTaskOnceLatchName;
    private boolean removeEmpty;
    private EvictionScheduler evictionScheduler;
    private String publishCommand;

    public MapCacheEvictionTask(String name, String timeoutSetName, String maxIdleSetName, String expiredChannelName, String lastAccessTimeSetName, CommandAsyncExecutor executor, boolean removeEmpty, EvictionScheduler evictionScheduler, String publishCommand) {
        super(executor);
        this.name = name;
        this.timeoutSetName = timeoutSetName;
        this.maxIdleSetName = maxIdleSetName;
        this.expiredChannelName = expiredChannelName;
        this.lastAccessTimeSetName = lastAccessTimeSetName;
        this.executeTaskOnceLatchName = RedissonObject.prefixName("redisson__execute_task_once_latch", name);
        this.removeEmpty = removeEmpty;
        this.evictionScheduler = evictionScheduler;
        this.publishCommand = publishCommand;
    }

    @Override
    String getName() {
        return this.name;
    }

    @Override
    CompletionStage<Integer> execute() {
        int latchExpireTime = Math.min(this.delay, 30);
        RFuture<Integer> expiredFuture = this.executor.evalWriteNoRetryAsync(this.name, LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "if redis.call('setnx', KEYS[6], ARGV[4]) == 0 then return -1;end;redis.call('expire', KEYS[6], ARGV[3]); local expiredKeys1 = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); for i, key in ipairs(expiredKeys1) do local v = redis.call('hget', KEYS[1], key); if v ~= false then local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(val), val); local listeners = redis.call(ARGV[5], KEYS[4], msg); if (listeners == 0) then break;end; end;end;for i=1, #expiredKeys1, 5000 do redis.call('zrem', KEYS[5], unpack(expiredKeys1, i, math.min(i+4999, table.getn(expiredKeys1)))); redis.call('zrem', KEYS[3], unpack(expiredKeys1, i, math.min(i+4999, table.getn(expiredKeys1)))); redis.call('zrem', KEYS[2], unpack(expiredKeys1, i, math.min(i+4999, table.getn(expiredKeys1)))); redis.call('hdel', KEYS[1], unpack(expiredKeys1, i, math.min(i+4999, table.getn(expiredKeys1)))); end; local expiredKeys2 = redis.call('zrangebyscore', KEYS[3], 0, ARGV[1], 'limit', 0, ARGV[2]); for i, key in ipairs(expiredKeys2) do local v = redis.call('hget', KEYS[1], key); if v ~= false then local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(val), val); local listeners = redis.call(ARGV[5], KEYS[4], msg); if (listeners == 0) then break;end; end;end;for i=1, #expiredKeys2, 5000 do redis.call('zrem', KEYS[5], unpack(expiredKeys2, i, math.min(i+4999, table.getn(expiredKeys2)))); redis.call('zrem', KEYS[3], unpack(expiredKeys2, i, math.min(i+4999, table.getn(expiredKeys2)))); redis.call('zrem', KEYS[2], unpack(expiredKeys2, i, math.min(i+4999, table.getn(expiredKeys2)))); redis.call('hdel', KEYS[1], unpack(expiredKeys2, i, math.min(i+4999, table.getn(expiredKeys2)))); end; return #expiredKeys1 + #expiredKeys2;", Arrays.asList(this.name, this.timeoutSetName, this.maxIdleSetName, this.expiredChannelName, this.lastAccessTimeSetName, this.executeTaskOnceLatchName), System.currentTimeMillis(), this.keysLimit, latchExpireTime, 1, this.publishCommand);
        if (this.removeEmpty) {
            CompletionStage r = expiredFuture.thenCompose(removed -> {
                RFuture s = this.executor.readAsync(this.name, (Codec)IntegerCodec.INSTANCE, RedisCommands.HLEN, this.name);
                return s.thenCompose(size -> {
                    if (size == 0) {
                        this.evictionScheduler.remove(this.name);
                        RFuture f = this.executor.writeAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.DEL, this.name);
                        return f.thenApply(res -> removed);
                    }
                    return CompletableFuture.completedFuture(removed);
                });
            });
            return new CompletableFutureWrapper<Integer>(r);
        }
        return expiredFuture;
    }
}

