/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RScheduledFuture;
import org.redisson.executor.RedissonExecutorFuture;
import org.redisson.executor.RemotePromise;

public class RedissonScheduledFuture<V>
extends RedissonExecutorFuture<V>
implements RScheduledFuture<V> {
    private final long scheduledExecutionTime;
    private final RemotePromise<V> promise;

    public RedissonScheduledFuture(RemotePromise<V> promise, long scheduledExecutionTime) {
        super(promise);
        this.scheduledExecutionTime = scheduledExecutionTime;
        this.promise = promise;
    }

    public RemotePromise<V> getInnerPromise() {
        return this.promise;
    }

    @Override
    public int compareTo(Delayed other) {
        if (this == other) {
            return 0;
        }
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        if (diff == 0L) {
            return 0;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.scheduledExecutionTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

