/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.redisson.api.AsyncIterator;

public class CompositeAsyncIterator<T>
implements AsyncIterator<T> {
    private final Iterator<AsyncIterator<T>> iterator;
    private AsyncIterator<T> currentAsyncIterator;
    private final int limit;
    private int counter;

    public CompositeAsyncIterator(List<AsyncIterator<T>> asyncIterators, int limit) {
        this.iterator = asyncIterators.iterator();
        this.limit = limit;
    }

    @Override
    public CompletionStage<Boolean> hasNext() {
        if (this.limit > 0 && this.limit <= this.counter) {
            return CompletableFuture.completedFuture(false);
        }
        while (this.currentAsyncIterator == null && this.iterator.hasNext()) {
            this.currentAsyncIterator = this.iterator.next();
        }
        if (this.currentAsyncIterator == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletionStage<Boolean> main = this.currentAsyncIterator.hasNext();
        return main.thenCompose(v -> {
            if (v.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            this.currentAsyncIterator = null;
            return this.hasNext();
        });
    }

    @Override
    public CompletionStage<T> next() {
        CompletableFuture result = new CompletableFuture();
        this.hasNext().thenAccept(v1 -> {
            if (!v1.booleanValue()) {
                result.completeExceptionally(new NoSuchElementException());
                return;
            }
            this.currentAsyncIterator.next().whenComplete((v2, e2) -> {
                if (e2 != null) {
                    result.completeExceptionally(new CompletionException((Throwable)e2));
                    return;
                }
                result.complete(v2);
                ++this.counter;
            });
        });
        return result;
    }
}

