/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.misc.WrappedLock;

public final class FastRemovalQueue<E> {
    private final Map<E, Node<E>> index = new ConcurrentHashMap<E, Node<E>>();
    private final DoublyLinkedList<E> list = new DoublyLinkedList();

    public void add(E element) {
        Node<E> newNode = new Node<E>(element);
        if (this.index.putIfAbsent(element, newNode) == null) {
            this.list.add(newNode);
        }
    }

    public boolean moveToTail(E element) {
        Node<E> node = this.index.get(element);
        if (node != null) {
            this.list.moveToTail(node);
            return true;
        }
        return false;
    }

    public boolean remove(E element) {
        Node<E> node = this.index.remove(element);
        if (node != null) {
            return this.list.remove(node);
        }
        return false;
    }

    public int size() {
        return this.index.size();
    }

    public E poll() {
        Node<E> node = this.list.removeFirst();
        if (node != null) {
            this.index.remove(((Node)node).value);
            return (E)((Node)node).value;
        }
        return null;
    }

    public void clear() {
        this.index.clear();
        this.list.clear();
    }

    static class DoublyLinkedList<E> {
        private final WrappedLock lock = new WrappedLock();
        private Node<E> head;
        private Node<E> tail;

        DoublyLinkedList() {
        }

        public void clear() {
            this.lock.execute(() -> {
                this.head = null;
                this.tail = null;
            });
        }

        public void add(Node<E> newNode) {
            this.lock.execute(() -> this.addNode(newNode));
        }

        private void addNode(Node<E> newNode) {
            Node<E> currentTail = this.tail;
            this.tail = newNode;
            if (currentTail == null) {
                this.head = newNode;
            } else {
                ((Node)newNode).prev = (Node)currentTail;
                ((Node)currentTail).next = (Node)newNode;
            }
        }

        public boolean remove(Node<E> node) {
            Boolean r = this.lock.execute(() -> {
                if (node.isDeleted()) {
                    return false;
                }
                this.removeNode(node);
                node.setDeleted();
                return true;
            });
            return Boolean.TRUE.equals(r);
        }

        private void removeNode(Node<E> node) {
            Node prevNode = ((Node)node).prev;
            Node nextNode = ((Node)node).next;
            if (prevNode != null) {
                prevNode.next = nextNode;
            } else {
                this.head = nextNode;
            }
            if (nextNode != null) {
                nextNode.prev = prevNode;
            } else {
                this.tail = prevNode;
            }
        }

        public void moveToTail(Node<E> node) {
            this.lock.execute(() -> {
                if (node.isDeleted()) {
                    return;
                }
                this.removeNode(node);
                ((Node)node).prev = null;
                ((Node)node).next = null;
                this.addNode(node);
            });
        }

        public Node<E> removeFirst() {
            return this.lock.execute(() -> {
                Node<E> currentHead = this.head;
                if (this.head == this.tail) {
                    this.head = null;
                    this.tail = null;
                } else {
                    this.head = ((Node)this.head).next;
                    ((Node)this.head).prev = null;
                }
                if (currentHead != null) {
                    currentHead.setDeleted();
                }
                return currentHead;
            });
        }
    }

    static class Node<E> {
        private final E value;
        private Node<E> prev;
        private Node<E> next;
        private boolean deleted;

        Node(E value) {
            this.value = value;
        }

        public void setDeleted() {
            this.deleted = true;
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

