/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.NetUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class RedisURI {
    public static final String REDIS_PROTOCOL = "redis://";
    public static final String REDIS_SSL_PROTOCOL = "rediss://";
    public static final String REDIS_UDS_PROTOCOL = "redis+uds://";
    public static final String VALKEY_PROTOCOL = "valkey://";
    public static final String VALKEY_SSL_PROTOCOL = "valkeys://";
    public static final String VALKEY_UDS_PROTOCOL = "valkey+uds://";
    private final String scheme;
    private final String host;
    private final int port;
    private String username;
    private String password;
    private int hashCode;

    public static boolean isValid(String url) {
        return url.startsWith(REDIS_PROTOCOL) || url.startsWith(REDIS_SSL_PROTOCOL) || url.startsWith(VALKEY_PROTOCOL) || url.startsWith(VALKEY_SSL_PROTOCOL) || url.startsWith(REDIS_UDS_PROTOCOL) || url.startsWith(VALKEY_UDS_PROTOCOL);
    }

    public RedisURI(String scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.hashCode = Objects.hash(this.isSsl(), host, port);
    }

    public RedisURI(String uri) {
        if (!RedisURI.isValid(uri)) {
            throw new IllegalArgumentException("Redis url should start with redis:// or rediss:// (for SSL connection)");
        }
        this.scheme = uri.split("://")[0];
        try {
            String[] details;
            if (this.isUDS()) {
                this.host = uri.split("://")[1];
                this.port = 0;
                return;
            }
            if (uri.split(":").length < 3) {
                throw new IllegalArgumentException("Redis url doesn't contain a port");
            }
            String urlHost = this.parseUrl(uri);
            URL url = new URL(urlHost);
            if (url.getUserInfo() != null && (details = url.getUserInfo().split(":", 2)).length == 2) {
                if (!details[0].isEmpty()) {
                    this.username = URLDecoder.decode(details[0], StandardCharsets.UTF_8.toString());
                }
                this.password = URLDecoder.decode(details[1], StandardCharsets.UTF_8.toString());
            }
            if (url.getHost().isEmpty()) {
                throw new IllegalArgumentException("Redis host can't be parsed");
            }
            this.host = url.getHost();
            this.port = url.getPort();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String parseUrl(String uri) {
        int hostStartIndex = uri.indexOf("://") + 3;
        String urlHost = "http://" + uri.substring(hostStartIndex);
        String ipV6Host = uri.substring(hostStartIndex, uri.lastIndexOf(":"));
        if (ipV6Host.contains("@")) {
            ipV6Host = ipV6Host.split("@")[1];
        }
        if (ipV6Host.contains(":") && !ipV6Host.startsWith("[")) {
            urlHost = urlHost.replace(ipV6Host, "[" + ipV6Host + "]");
        }
        return urlHost;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return "rediss".equals(this.scheme) || "valkeys".equals(this.scheme);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUDS() {
        return "redis+uds".equals(this.scheme) || "valkey+uds".equals(this.scheme);
    }

    public boolean isIP() {
        return NetUtil.createByteArrayFromIpAddressString(this.host) != null;
    }

    private String trimIpv6Brackets(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    public boolean equals(InetSocketAddress entryAddr) {
        String ip = this.trimIpv6Brackets(this.getHost());
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(ip) || entryAddr.getAddress().getHostAddress().equals(ip)) && entryAddr.getPort() == this.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        return this.isSsl() == redisURI.isSsl() && this.port == redisURI.port && Objects.equals(this.host, redisURI.host);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getScheme() + "://" + this.trimIpv6Brackets(this.host) + ":" + this.port;
    }
}

