/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.redisson.hibernate.region.RedissonNaturalIdRegion;
import org.redisson.hibernate.strategy.BaseRegionAccessStrategy;

public class ReadOnlyNaturalIdRegionAccessStrategy
extends BaseRegionAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public ReadOnlyNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region) {
        super(settings, region);
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.region.get(session, key);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && this.region.contains(key)) {
            return false;
        }
        this.region.put(session, key, value);
        return true;
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.evict(key);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        this.region.put(session, key, value);
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        throw new UnsupportedOperationException("Unable to update read-only object");
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Unable to update read-only object");
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return ((RedissonNaturalIdRegion)this.region).getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return ((RedissonNaturalIdRegion)this.region).getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

