/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import java.util.Set;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.redisson.MapCacheNativeWrapper;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheNative;
import org.redisson.hibernate.RedissonRegionFactory;

public class RedissonRegionNativeFactory
extends RedissonRegionFactory {
    private static final long serialVersionUID = 4889779229712681692L;

    @Override
    protected void prepareForUse(SessionFactoryOptions settings, Map properties) throws CacheException {
        Set entrySet = properties.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer value;
            if (entry.getKey().toString().endsWith(".eviction.max_entries") && (value = Integer.valueOf(entry.getValue().toString())) > 0) {
                throw new IllegalArgumentException(".eviction.max_entries setting can't be non-zero");
            }
            if (!entry.getKey().toString().endsWith(".expiration.max_idle_time") || (value = Integer.valueOf(entry.getValue().toString())) <= 0) continue;
            throw new IllegalArgumentException(".expiration.max_idle_time setting can't be non-zero");
        }
        super.prepareForUse(settings, properties);
    }

    @Override
    protected RMapCache<Object, Object> getCache(String regionName, Map properties, String defaultKey) {
        RMapCacheNative cache = this.redisson.getMapCacheNative(regionName);
        return new MapCacheNativeWrapper(cache);
    }
}

