/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveKeyCommands
extends RedissonBaseReactive
implements ReactiveKeyCommands {
    private static final RedisStrictCommand<DataType> TYPE = new RedisStrictCommand("TYPE", (Convertor)new Convertor<DataType>(){

        public DataType convert(Object obj) {
            return DataType.fromCode((String)obj.toString());
        }
    });
    static final RedisStrictCommand<String> RENAME = new RedisStrictCommand("RENAME");
    private static final RedisStrictCommand<Boolean> EXPIRE = new RedisStrictCommand("EXPIRE", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Boolean> EXPIREAT = new RedisStrictCommand("EXPIREAT", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> TTL = new RedisStrictCommand("TTL");

    public RedissonReactiveKeyCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.EXISTS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(key, v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(key.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TYPE, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(key, v));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> patterns) {
        return this.execute(patterns, pattern -> {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
            Mono m = this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.KEYS, new Object[]{RedissonReactiveKeyCommands.toByteArray(pattern)});
            return m.map(v -> {
                List values = v.stream().map(t -> ByteBuffer.wrap(t.getBytes())).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse(pattern, values);
            });
        });
    }

    public Mono<ByteBuffer> randomKey() {
        return this.executorService.reactive(() -> this.executorService.readRandomAsync((Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]));
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewName(), (String)"New name must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveKeyCommands.toByteArray(command.getNewName());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RENAME, keyBuf, newKeyBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewName(), (String)"New name must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveKeyCommands.toByteArray(command.getNewName());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RENAMENX, keyBuf, newKeyBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        Flux s = Flux.from(keys);
        return s.concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DEL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> keys) {
        return this.execute(keys, coll -> {
            Assert.notNull((Object)coll, (String)"List must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveKeyCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono m = this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DEL, params);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(coll, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> expire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIRE, keyBuf, command.getTimeout().getSeconds());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> pExpire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PEXPIRE, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> expireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIREAT, keyBuf, command.getExpireAt().getEpochSecond());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> pExpireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PEXPIREAT, keyBuf, command.getExpireAt().toEpochMilli());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PERSIST, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TTL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PTTL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDatabase(), (String)"Database must not be null!");
            byte[] keyBuf = RedissonReactiveKeyCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MOVE, keyBuf, command.getDatabase());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }
}

