/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveListCommands
extends RedissonBaseReactive
implements ReactiveListCommands {
    private static final RedisStrictCommand<Long> RPUSH = new RedisStrictCommand("RPUSH");
    private static final RedisStrictCommand<Long> LPUSH = new RedisStrictCommand("LPUSH");
    private static final RedisStrictCommand<Long> RPUSHX = new RedisStrictCommand("RPUSHX");
    private static final RedisStrictCommand<Long> LPUSHX = new RedisStrictCommand("LPUSHX");
    private static final RedisStrictCommand<Long> LLEN = new RedisStrictCommand("LLEN");
    private static final RedisStrictCommand<String> LTRIM = new RedisStrictCommand("LTRIM");
    private static final RedisStrictCommand<Long> LINSERT = new RedisStrictCommand("LINSERT");
    private static final RedisStrictCommand<String> LSET = new RedisStrictCommand("LSET");
    private static final RedisStrictCommand<Long> LREM = new RedisStrictCommand("LREM");

    RedissonReactiveListCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.PushCommand, Long>> push(Publisher<ReactiveListCommands.PushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty((Collection)command.getValues(), (String)"Values must not be null or empty!");
            if (!command.getUpsert() && command.getValues().size() > 1) {
                throw new InvalidDataAccessApiUsageException(String.format("%s PUSHX only allows one value!", command.getDirection()));
            }
            ArrayList<byte[]> params = new ArrayList<byte[]>();
            params.add(RedissonReactiveListCommands.toByteArray(command.getKey()));
            params.addAll(command.getValues().stream().map(v -> RedissonReactiveListCommands.toByteArray(v)).collect(Collectors.toList()));
            RedisStrictCommand<Long> redisCommand = ObjectUtils.nullSafeEquals((Object)ReactiveListCommands.Direction.RIGHT, (Object)command.getDirection()) ? (command.getUpsert() ? RPUSH : RPUSHX) : (command.getUpsert() ? LPUSH : LPUSHX);
            Mono m = this.write((byte[])params.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)redisCommand, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> lLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, key -> {
            Assert.notNull((Object)key.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(key.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LLEN, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(key, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.RangeCommand, Flux<ByteBuffer>>> lRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.LRANGE, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>> lTrim(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LTRIM, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LIndexCommand>> lIndex(Publisher<ReactiveListCommands.LIndexCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getIndex(), (String)"Index value must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.LINDEX, keyBuf, command.getIndex());
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LInsertCommand, Long>> lInsert(Publisher<ReactiveListCommands.LInsertCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.notNull((Object)command.getPivot(), (String)"Pivot must not be null!");
            Assert.notNull((Object)command.getPosition(), (String)"Position must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            byte[] pivotBuf = RedissonReactiveListCommands.toByteArray(command.getPivot());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LINSERT, keyBuf, command.getPosition(), pivotBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveListCommands.LSetCommand>> lSet(Publisher<ReactiveListCommands.LSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"value must not be null!");
            Assert.notNull((Object)command.getIndex(), (String)"Index must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LSET, keyBuf, command.getIndex(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LRemCommand, Long>> lRem(Publisher<ReactiveListCommands.LRemCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.notNull((Object)command.getCount(), (String)"Count must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LREM, keyBuf, command.getCount(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.PopCommand>> pop(Publisher<ReactiveListCommands.PopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDirection(), (String)"Direction must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            RedisCommand redisCommand = RedisCommands.LPOP;
            if (command.getDirection() == ReactiveListCommands.Direction.RIGHT) {
                redisCommand = RedisCommands.RPOP;
            }
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, redisCommand, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveListCommands.PopResponse> bPop(Publisher<ReactiveListCommands.BPopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getDirection(), (String)"Direction must not be null!");
            Assert.notNull((Object)command.getTimeout(), (String)"Timeout must not be null!");
            RedisCommand redisCommand = RedisCommands.BLPOP;
            if (command.getDirection() == ReactiveListCommands.Direction.RIGHT) {
                redisCommand = RedisCommands.BRPOP;
            }
            ArrayList<Long> params = new ArrayList<Long>(command.getKeys().size() + 1);
            params.addAll(command.getKeys().stream().map(v -> RedissonReactiveListCommands.toByteArray(v)).collect(Collectors.toList()));
            params.add(command.getTimeout().getSeconds());
            Mono m = this.write((byte[])params.get(0), (Codec)ByteArrayCodec.INSTANCE, redisCommand, params.toArray());
            return m.map(v -> new ReactiveListCommands.PopResponse(command, new ReactiveListCommands.PopResult(v.stream().map(e -> ByteBuffer.wrap(e)).collect(Collectors.toList()))));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>> rPopLPush(Publisher<ReactiveListCommands.RPopLPushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestination());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.RPOPLPUSH, keyBuf, destinationBuf);
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BRPopLPushCommand>> bRPopLPush(Publisher<ReactiveListCommands.BRPopLPushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            Assert.notNull((Object)command.getTimeout(), (String)"Timeout must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestination());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.BRPOPLPUSH, keyBuf, destinationBuf, command.getTimeout().getSeconds());
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }
}

