/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Util;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.Signature;
import org.redline_rpm.payload.CpioHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scanner.class);
    private final PrintStream output;

    public Scanner() {
        this(null);
    }

    public Scanner(PrintStream out) {
        this.output = out;
    }

    public static void main(String[] args) throws Exception {
        CpioHeader header;
        FileInputStream fios = new FileInputStream(args[0]);
        ReadableChannelWrapper in = new ReadableChannelWrapper(Channels.newChannel(fios));
        Scanner scanner = new Scanner(System.out);
        Format format = scanner.run(in);
        scanner.log(format.toString());
        Header rpmHeader = format.getHeader();
        scanner.log("Payload compression: " + rpmHeader.getEntry(Header.HeaderTag.PAYLOADCOMPRESSOR));
        InputStream uncompressed = Util.openPayloadStream(rpmHeader, fios);
        in = new ReadableChannelWrapper(Channels.newChannel(uncompressed));
        int total = 0;
        do {
            header = new CpioHeader();
            total = header.read(in, total);
            scanner.log(header.toString());
            int skip = header.getFileSize();
            if (uncompressed.skip(skip) != (long)skip) {
                throw new RuntimeException("Skip failed.");
            }
            total += header.getFileSize();
        } while (!header.isLast());
    }

    public Format run(ReadableChannelWrapper in) throws IOException {
        Format format = new Format();
        ChannelWrapper.Key<Integer> headerStartKey = in.start();
        ChannelWrapper.Key<Integer> lead = in.start();
        format.getLead().read(in);
        this.log("Lead ended at '" + in.finish(lead) + "'.");
        ChannelWrapper.Key<Integer> signature = in.start();
        int count = format.getSignature().read(in);
        AbstractHeader.Entry<?> sigEntry = format.getSignature().getEntry(Signature.SignatureTag.SIGNATURES);
        int expected = sigEntry == null ? 0 : ByteBuffer.wrap((byte[])sigEntry.getValues(), 8, 4).getInt() / -16;
        this.log("Signature ended at '" + in.finish(signature) + "' and contained '" + count + "' headers (expected '" + expected + "').");
        Integer headerStartPos = in.finish(headerStartKey);
        format.getHeader().setStartPos(headerStartPos);
        ChannelWrapper.Key<Integer> headerKey = in.start();
        count = format.getHeader().read(in);
        AbstractHeader.Entry<?> immutableEntry = format.getHeader().getEntry(Header.HeaderTag.HEADERIMMUTABLE);
        expected = immutableEntry == null ? 0 : ByteBuffer.wrap((byte[])immutableEntry.getValues(), 8, 4).getInt() / -16;
        Integer headerLength = in.finish(headerKey);
        format.getHeader().setEndPos(headerStartPos + headerLength);
        this.log("Header ended at '" + headerLength + " and contained '" + count + "' headers (expected '" + expected + "').");
        return format;
    }

    private void log(String text) {
        if (this.output == null) {
            LOGGER.info(text);
        } else {
            this.output.println(text);
        }
    }
}

