/**
 * Copyright (c) 2012 Reficio (TM) - Reestablish your software! All Rights Reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.reficio.p2.resolver.maven.impl.facade

import org.reficio.p2.resolver.maven.Artifact

/**
 * @author Tom Bujok (tom.bujok@gmail.com)<br>
 *         Reficio (TM) - Reestablish your software!<br>
 *         http://www.reficio.org
 * @since 1.1.0
 */
interface AetherFacade {

    def newDependencyRequest(dependencyNode, dependencyFilter)

    def newPreorderNodeListGenerator()

    def newCollectRequest()

    def newDependency(defaultArtifact, String scope)

    def newDefaultArtifact(artifact)

    def newArtifactRequest()

    def newSubArtifact(artifact, String classifier, String extension)

    def newPatternExclusionsDependencyFilter(List<String> excludes)

    def newDependencyFilter(filterClosure)

    Artifact translateArtifactAetherToGeneric(artifact)

    def translateArtifactGenericToAether(Artifact artifact)

}