/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.bundler;

import java.util.HashMap;
import java.util.Map;

public final class ArtifactBundlerInstructions {
    private final String name;
    private final String symbolicName;
    private final String symbolicNameWithOptions;
    private final String version;
    private final String sourceName;
    private final String sourceSymbolicName;
    private final String proposedVersion;
    private final Map<?, ?> instructions;
    private final Boolean snapshot;

    private ArtifactBundlerInstructions(String name, String symbolicName, String symbolicNameWithOptions, String version, String sourceName, String sourceSymbolicName, String proposedVersion, Map instructions, Boolean snapshot) {
        this.name = name;
        this.symbolicName = symbolicName;
        this.symbolicNameWithOptions = symbolicNameWithOptions;
        this.version = version;
        this.sourceName = sourceName;
        this.sourceSymbolicName = sourceSymbolicName;
        this.proposedVersion = proposedVersion;
        this.instructions = instructions;
        this.snapshot = snapshot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getSymbolicNameWithOptions() {
        return this.symbolicNameWithOptions;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceSymbolicName() {
        return this.sourceSymbolicName;
    }

    public String getProposedVersion() {
        return this.proposedVersion;
    }

    public Map<?, ?> getInstructions() {
        return this.instructions;
    }

    public Boolean isSnapshot() {
        return this.snapshot;
    }

    public static final class Builder {
        private String name;
        private String symbolicName;
        private String symbolicNameWithOptions;
        private String version;
        private String sourceName;
        private String sourceSymbolicName;
        private String proposedVersion;
        private Map<?, ?> instructions = new HashMap();
        private Boolean snapshot;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public Builder symbolicNameWithOptions(String symbolicNameWithOptions) {
            this.symbolicNameWithOptions = symbolicNameWithOptions;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourceSymbolicName(String sourceSymbolicName) {
            this.sourceSymbolicName = sourceSymbolicName;
            return this;
        }

        public Builder proposedVersion(String proposedVersion) {
            this.proposedVersion = proposedVersion;
            return this;
        }

        public <X, Y> Builder instructions(Map<X, Y> instructions) {
            this.instructions = new HashMap<X, Y>(instructions);
            return this;
        }

        public Builder snapshot(Boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public ArtifactBundlerInstructions build() {
            return new ArtifactBundlerInstructions(this.name, this.symbolicName, this.symbolicNameWithOptions, this.version, this.sourceName, this.sourceSymbolicName, this.proposedVersion, this.instructions, this.snapshot);
        }
    }
}

