/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.utils;

import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

public class JarUtils {
    private static final String JAR_SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static final String OSGI_SNAPSHOT_POSTFIX = ".SNAPSHOT";
    private static final String ECLIPSE_QUALIFIER_POSTFIX = ".qualifier";

    public static void adjustSnapshotOutputVersion(File inputFile, File outputFile, String version) {
        Jar jar = null;
        try {
            jar = new Jar(inputFile);
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Bundle-Version", version);
            jar.write(outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open jar " + outputFile, e);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static void adjustFeatureQualifierVersionWithTimestamp(File inputFile, File outputFile) {
        Jar jar = null;
        try {
            jar = new Jar(inputFile);
            Resource res = jar.getResource("feature.xml");
            Document featureSpec = JarUtils.parseXml(res.openInputStream());
            String version = featureSpec.getDocumentElement().getAttributeNode("version").getValue();
            String newVersion = JarUtils.replaceQualifierWithTimestamp(version);
            featureSpec.getDocumentElement().getAttributeNode("version").setValue(newVersion);
            File newXml = new File(inputFile.getParentFile(), "feature.xml");
            JarUtils.writeXml(featureSpec, newXml);
            FileResource newRes = new FileResource(newXml);
            jar.putResource("feature.xml", (Resource)newRes, true);
            jar.write(outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open jar " + outputFile, e);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static Document parseXml(InputStream input) {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setValidating(false);
            DocumentBuilder docBuilder = fac.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse XML input", e);
        }
    }

    public static void writeXml(Document doc, File outputFile) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(outputFile);
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot write XML document to file " + outputFile.getName(), e);
        }
    }

    public static String replaceQualifierWithTimestamp(String version) {
        String tweakedVersion = version;
        if (version.contains(ECLIPSE_QUALIFIER_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(ECLIPSE_QUALIFIER_POSTFIX, "." + JarUtils.getTimeStamp());
        }
        return tweakedVersion;
    }

    public static String replaceSnapshotWithTimestamp(String version) {
        String tweakedVersion = version;
        if (version.contains(JAR_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(JAR_SNAPSHOT_POSTFIX, "-" + JarUtils.getTimeStamp());
        } else if (version.contains(OSGI_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(OSGI_SNAPSHOT_POSTFIX, "." + JarUtils.getTimeStamp());
        }
        return tweakedVersion;
    }

    public static String getTimeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSignature(File jar) {
        File unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
        try {
            if (unsignedJar.exists()) {
                FileUtils.deleteQuietly((File)unsignedJar);
                unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
            }
            if (!unsignedJar.createNewFile()) {
                throw new RuntimeException("Cannot create file " + unsignedJar);
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(unsignedJar));
            try {
                ZipFile zip = new ZipFile(jar);
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF")) continue;
                    InputStream zipInputStream = zip.getInputStream(entry);
                    zipOutputStream.putNextEntry(entry);
                    try {
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        zipInputStream.close();
                    }
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                FileUtils.copyFile((File)unsignedJar, (File)jar);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)unsignedJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsSignature(File jarToUnsign) {
        try {
            ZipFile zip = new ZipFile(jarToUnsign);
            try {
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".RSA") && !name.endsWith(".DSA") && !name.endsWith(".SF")) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                zip.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

