/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.utils;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static Document parseXml(InputStream input) {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setValidating(false);
            DocumentBuilder docBuilder = fac.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void writeXml(Document doc, File outputFile) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(outputFile);
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Element fetchOrCreateElement(Document doc, Node parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                if (!((Element)n).getTagName().equals(tagName)) continue;
                return e;
            }
        }
        return XmlUtils.createElement(doc, parent, tagName);
    }

    public static Element createElement(Document doc, Node parent, String tagName) {
        Element e = doc.createElement(tagName);
        parent.appendChild(e);
        return e;
    }
}

