/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.publisher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

public class CategoryPublisher {
    private static final String CATEGORY_PUBLISHER_APP_NAME = "org.eclipse.equinox.p2.publisher.CategoryPublisher";
    private final P2ApplicationLauncher launcher;
    private final int forkedProcessTimeoutInSeconds;
    private final String[] additionalArgs;
    private final String categoryFileLocation;
    private final String metadataRepositoryLocation;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CategoryPublisher(P2ApplicationLauncher launcher, int forkedProcessTimeoutInSeconds, String[] additionalArgs, String categoryFileLocation, String metadataRepositoryLocation) {
        this.launcher = launcher;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.additionalArgs = additionalArgs;
        this.categoryFileLocation = categoryFileLocation;
        this.metadataRepositoryLocation = metadataRepositoryLocation;
    }

    public void execute() throws AbstractMojoExecutionException, IOException {
        this.configureLauncher(this.categoryFileLocation, this.metadataRepositoryLocation);
        this.executeLauncher();
    }

    private void configureLauncher(String categoryFileLocation, String metadataRepositoryLocation) throws AbstractMojoExecutionException, IOException {
        File metadataRepositoryDir = new File(metadataRepositoryLocation).getCanonicalFile();
        File categoryDefinitionFileSource = new File(categoryFileLocation);
        File categoryDefinitionFileTarget = new File(metadataRepositoryDir, "category.xml");
        FileUtils.copyFile((File)categoryDefinitionFileSource, (File)categoryDefinitionFileTarget);
        this.launcher.setWorkingDirectory(metadataRepositoryDir);
        this.launcher.setApplicationName(CATEGORY_PUBLISHER_APP_NAME);
        this.launcher.addArguments(new String[]{"-categoryDefinition", "file:/" + new File(categoryDefinitionFileTarget.toURI()).getAbsolutePath()});
        this.launcher.addArguments(new String[]{"-metadataRepository", "file:/" + new File(metadataRepositoryDir.toURI()).getAbsolutePath()});
        this.launcher.addArguments(this.additionalArgs);
    }

    private void executeLauncher() throws MojoFailureException {
        int result = this.launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private P2ApplicationLauncher launcher;
        private int forkedProcessTimeoutInSeconds = 0;
        private String[] additionalArgs;
        private String categoryFileLocation;
        private String metadataRepositoryLocation;

        public Builder p2ApplicationLauncher(P2ApplicationLauncher launcher) {
            Objects.requireNonNull(launcher, "p2ApplicationLauncher cannot be null");
            this.launcher = launcher;
            return this;
        }

        public Builder forkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
            if (forkedProcessTimeoutInSeconds < 0) {
                throw new IllegalArgumentException("forkedProcessTimeoutInSeconds cannot be negative but was: " + forkedProcessTimeoutInSeconds);
            }
            this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
            return this;
        }

        public Builder additionalArgs(String additionalArgs) {
            try {
                this.additionalArgs = CommandLineUtils.translateCommandline((String)additionalArgs);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to translate additional arguments into command line array", e);
            }
            return this;
        }

        public Builder categoryFileLocation(String categoryFileLocation) {
            Objects.requireNonNull(categoryFileLocation, "categoryFileLocation cannot be null");
            this.categoryFileLocation = categoryFileLocation;
            return this;
        }

        public Builder metadataRepositoryLocation(String metadataRepositoryLocation) {
            Objects.requireNonNull(metadataRepositoryLocation, "metadataRepositoryLocation cannot be null");
            this.metadataRepositoryLocation = metadataRepositoryLocation;
            return this;
        }

        public CategoryPublisher build() {
            Objects.requireNonNull(this.launcher, "p2ApplicationLauncher cannot be null");
            Objects.requireNonNull(this.categoryFileLocation, "categoryFileLocation cannot be null");
            Objects.requireNonNull(this.metadataRepositoryLocation, "metadataRepositoryLocation cannot be null");
            return new CategoryPublisher(this.launcher, this.forkedProcessTimeoutInSeconds, this.additionalArgs, this.categoryFileLocation, this.metadataRepositoryLocation);
        }
    }
}

