/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.bundler;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ArtifactBundlerInstructions {
    private static Map<String, String> DEFAULT_INSTRUCTIONS = new LinkedHashMap<String, String>();
    private final String name;
    private final String symbolicName;
    private final String symbolicNameWithOptions;
    private final String version;
    private final String sourceName;
    private final String sourceSymbolicName;
    private final String proposedVersion;
    private final Map<String, String> instructions;
    private final Boolean snapshot;

    private ArtifactBundlerInstructions(String name, String symbolicName, String symbolicNameWithOptions, String version, String sourceName, String sourceSymbolicName, String proposedVersion, Map<String, String> instructions, Boolean snapshot) {
        this.name = name;
        this.symbolicName = symbolicName;
        this.symbolicNameWithOptions = symbolicNameWithOptions;
        this.version = version;
        this.sourceName = sourceName;
        this.sourceSymbolicName = sourceSymbolicName;
        this.proposedVersion = proposedVersion;
        this.instructions = instructions.isEmpty() ? DEFAULT_INSTRUCTIONS : instructions;
        this.snapshot = snapshot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getSymbolicNameWithOptions() {
        return this.symbolicNameWithOptions;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceSymbolicName() {
        return this.sourceSymbolicName;
    }

    public String getProposedVersion() {
        return this.proposedVersion;
    }

    public Map<String, String> getInstructions() {
        return this.instructions;
    }

    public Boolean isSnapshot() {
        return this.snapshot;
    }

    static {
        DEFAULT_INSTRUCTIONS.put("_fixupmessages", "\"Classes found in the wrong directory\";is:=warning");
        DEFAULT_INSTRUCTIONS.put("_removeheaders", "Bnd-LastModified");
        DEFAULT_INSTRUCTIONS.put("_reproducible", "true");
    }

    public static final class Builder {
        private String name;
        private String symbolicName;
        private String symbolicNameWithOptions;
        private String version;
        private String sourceName;
        private String sourceSymbolicName;
        private String proposedVersion;
        private Map<String, String> instructions = new HashMap<String, String>();
        private Boolean snapshot;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public Builder symbolicNameWithOptions(String symbolicNameWithOptions) {
            this.symbolicNameWithOptions = symbolicNameWithOptions;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourceSymbolicName(String sourceSymbolicName) {
            this.sourceSymbolicName = sourceSymbolicName;
            return this;
        }

        public Builder proposedVersion(String proposedVersion) {
            this.proposedVersion = proposedVersion;
            return this;
        }

        public Builder instructions(Map<String, String> instructions) {
            this.instructions = new HashMap<String, String>(instructions);
            return this;
        }

        public Builder snapshot(Boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public ArtifactBundlerInstructions build() {
            return new ArtifactBundlerInstructions(this.name, this.symbolicName, this.symbolicNameWithOptions, this.version, this.sourceName, this.sourceSymbolicName, this.proposedVersion, this.instructions, this.snapshot);
        }
    }
}

