/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class P2Artifact {
    private String id;
    private boolean transitive = true;
    private boolean override = false;
    private boolean source = false;
    private boolean singleton = false;
    private List<String> excludes = new ArrayList<String>();
    private Map<String, String> instructions = new LinkedHashMap<String, String>();
    private Properties instructionsProperties = new Properties();
    private Map<String, String> combinedInstructions = new LinkedHashMap<String, String>();
    private boolean shouldResetCombinedInstructions = true;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(Map<String, String> instructions) {
        this.instructions = instructions;
        this.markCombinedInstructionsObsolete();
    }

    public boolean shouldIncludeTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    public boolean shouldOverrideManifest() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean shouldIncludeSources() {
        return this.source;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Properties getInstructionsProperties() {
        return this.instructionsProperties;
    }

    public void setInstructionsProperties(Properties instructionsProperties) {
        this.instructionsProperties = instructionsProperties;
        this.markCombinedInstructionsObsolete();
    }

    public Map<String, String> getCombinedInstructions() {
        if (this.shouldResetCombinedInstructions) {
            this.resetCombinedInstructions();
            this.shouldResetCombinedInstructions = false;
        }
        return this.combinedInstructions;
    }

    private void markCombinedInstructionsObsolete() {
        this.shouldResetCombinedInstructions = true;
    }

    private void resetCombinedInstructions() {
        this.combinedInstructions = new LinkedHashMap<String, String>();
        if (this.instructions != null) {
            this.combinedInstructions.putAll(this.instructions);
        }
        if (this.instructionsProperties != null) {
            for (String key : this.instructionsProperties.stringPropertyNames()) {
                this.combinedInstructions.put(key, this.instructionsProperties.getProperty(key));
            }
        }
    }
}

