/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ContentModelInferrer;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.SequenceParticle;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class ContentModelInferrerImpl
extends ContentModelInferrer {
    private static final Name START = new Name("", "#start");
    private static final Name END = new Name("", "#end");
    private final Map<Name, SingleNode> nameMap = new HashMap<Name, SingleNode>();
    private SingleNode prevNode;
    private final SingleNode startNode = this.lookup(START);
    private final SingleNode endNode = this.lookup(END);

    ContentModelInferrerImpl() {
        this.prevNode = this.startNode;
    }

    @Override
    public void addElement(Name name) {
        SingleNode singleNode = this.lookup(name);
        if (singleNode == this.prevNode) {
            this.prevNode.repeated = true;
        } else {
            this.prevNode.followingNodes.add(singleNode);
            this.prevNode = singleNode;
        }
    }

    @Override
    public void endSequence() {
        this.prevNode.followingNodes.add(this.endNode);
        this.prevNode = this.startNode;
    }

    private SingleNode lookup(Name name) {
        SingleNode singleNode = this.nameMap.get(name);
        if (singleNode == null) {
            singleNode = new SingleNode(name, this.nameMap.size());
            this.nameMap.put(name, singleNode);
        }
        return singleNode;
    }

    @Override
    public Particle inferContentModel() {
        if (this.startNode.followingNodes.size() == 0 || this.prevNode != this.startNode) {
            throw new IllegalStateException();
        }
        ParticleNode particleNode = new StronglyConnectedComponentsFinder(this.nameMap.size()).makeDag(this.lookup(START));
        int n = particleNode.index + 1;
        new ParticleMerger(n).merge(particleNode);
        return new ParticleBuilder(n).build(particleNode);
    }

    private static Particle makeParticle(Name name) {
        if (name == START || name == END) {
            return null;
        }
        return new ElementParticle(name);
    }

    @Override
    public Set<Name> getElementNames() {
        HashSet<Name> hashSet = new HashSet<Name>();
        hashSet.addAll(this.nameMap.keySet());
        hashSet.remove(START);
        hashSet.remove(END);
        return hashSet;
    }

    private static class ParticleMerger {
        private final boolean[] done;

        private ParticleMerger(int n) {
            this.done = new boolean[n];
        }

        void merge(ParticleNode particleNode) {
            if (this.done[particleNode.index]) {
                return;
            }
            this.done[particleNode.index] = true;
            if (particleNode.particle != null) {
                while (particleNode.followingNodes.size() == 1) {
                    ParticleNode particleNode2 = particleNode.followingNodes.iterator().next();
                    if (particleNode2.refCount != 1 || particleNode2.particle == null) break;
                    particleNode.particle = new SequenceParticle(particleNode.particle, particleNode2.particle);
                    particleNode.followingNodes = particleNode2.followingNodes;
                }
            }
            for (ParticleNode particleNode3 : particleNode.followingNodes) {
                this.merge(particleNode3);
            }
        }
    }

    private static class ParticleBuilder {
        private final int[] rank;
        private int currentRank = 0;
        private Particle rankParticleChoice;
        private Particle followParticle;
        int followRanksTotalRefCount = 0;
        int currentRankTotalRefCount = 0;
        int totalCoveredRefCount = 0;

        ParticleBuilder(int n) {
            this.rank = new int[n];
        }

        Particle build(ParticleNode particleNode) {
            this.visit(particleNode);
            if (this.followParticle == null) {
                this.followParticle = new EmptyParticle();
            }
            return this.followParticle;
        }

        void visit(ParticleNode particleNode) {
            int n;
            int n2 = 0;
            for (ParticleNode particleNode2 : particleNode.followingNodes) {
                if (this.rank[particleNode2.index] == 0) {
                    this.visit(particleNode2);
                }
                n2 = Math.max(n2, this.rank[particleNode2.index]);
            }
            this.rank[particleNode.index] = n = n2 + 1;
            if (n == this.currentRank) {
                this.rankParticleChoice = new ChoiceParticle(this.rankParticleChoice, particleNode.particle);
                this.currentRankTotalRefCount += particleNode.refCount;
            } else {
                if (this.totalCoveredRefCount != this.followRanksTotalRefCount) {
                    this.rankParticleChoice = new ChoiceParticle(this.rankParticleChoice, new EmptyParticle());
                }
                this.followParticle = this.followParticle == null ? this.rankParticleChoice : new SequenceParticle(this.rankParticleChoice, this.followParticle);
                this.followRanksTotalRefCount += this.currentRankTotalRefCount;
                this.rankParticleChoice = particleNode.particle;
                this.currentRankTotalRefCount = particleNode.refCount;
                this.currentRank = n;
            }
            this.totalCoveredRefCount += particleNode.followingNodes.size();
        }
    }

    private static class StronglyConnectedComponentsFinder {
        private final int[] visited;
        private final SingleNode[] root;
        private int visitIndex = 0;
        private final Stack<SingleNode> stack = new Stack();
        private final ParticleNode[] particleNodes;
        private final SingleNode[] singleNodes;
        private int nParticles = 0;

        StronglyConnectedComponentsFinder(int n) {
            this.visited = new int[n];
            this.root = new SingleNode[n];
            this.particleNodes = new ParticleNode[n];
            this.singleNodes = new SingleNode[n];
        }

        ParticleNode makeDag(SingleNode singleNode) {
            this.visit(singleNode);
            for (int i = 0; i < this.singleNodes.length; ++i) {
                for (SingleNode singleNode2 : this.singleNodes[i].followingNodes) {
                    this.particleNodes[i].addFollowing(this.particleNodes[singleNode2.index]);
                }
            }
            return this.particleNodes[singleNode.index];
        }

        void visit(SingleNode singleNode) {
            this.root[singleNode.index] = singleNode;
            this.visited[singleNode.index] = ++this.visitIndex;
            this.singleNodes[singleNode.index] = singleNode;
            this.stack.push(singleNode);
            for (SingleNode object : singleNode.followingNodes) {
                if (this.visited[object.index] == 0) {
                    this.visit(object);
                }
                if (this.particleNodes[object.index] != null) continue;
                this.root[singleNode.index] = this.firstVisited(this.root[singleNode.index], this.root[object.index]);
            }
            if (this.root[singleNode.index] == singleNode) {
                Object object2 = this.stack.pop();
                ParticleNode particleNode = new ParticleNode(this.nParticles++);
                particleNode.particle = ContentModelInferrerImpl.makeParticle(((SingleNode)object2).name);
                this.particleNodes[((SingleNode)object2).index] = particleNode;
                if (object2 != singleNode) {
                    do {
                        object2 = this.stack.pop();
                        this.particleNodes[((SingleNode)object2).index] = particleNode;
                        particleNode.particle = new ChoiceParticle(ContentModelInferrerImpl.makeParticle(((SingleNode)object2).name), particleNode.particle);
                    } while (object2 != singleNode);
                    particleNode.particle = new OneOrMoreParticle(particleNode.particle);
                } else if (((SingleNode)object2).repeated) {
                    particleNode.particle = new OneOrMoreParticle(particleNode.particle);
                }
            }
        }

        SingleNode firstVisited(SingleNode singleNode, SingleNode singleNode2) {
            return this.visited[singleNode.index] < this.visited[singleNode2.index] ? singleNode : singleNode2;
        }
    }

    private static class ParticleNode {
        final int index;
        Particle particle;
        int refCount = 0;
        Set<ParticleNode> followingNodes = new HashSet<ParticleNode>();

        ParticleNode(int n) {
            this.index = n;
        }

        void addFollowing(ParticleNode particleNode) {
            if (particleNode != this && !this.followingNodes.contains(particleNode)) {
                ++particleNode.refCount;
                this.followingNodes.add(particleNode);
            }
        }
    }

    private static class SingleNode {
        final Set<SingleNode> followingNodes = new HashSet<SingleNode>();
        final Name name;
        final int index;
        boolean repeated = false;

        SingleNode(Name name, int n) {
            this.name = name;
            this.index = n;
        }
    }
}

