/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.reploop.parser.ParserDriver;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.PostProcessor;
import org.reploop.parser.thrift.ThriftAstBuilder;
import org.reploop.parser.thrift.ThriftErrorListener;
import org.reploop.parser.thrift.base.ThriftBaseLexer;
import org.reploop.parser.thrift.base.ThriftBaseParser;
import org.reploop.parser.thrift.tree.ThriftProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftParser
extends ParserDriver<Node, ThriftBaseLexer, ThriftBaseParser> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftParser.class);

    public ThriftProgram program(Path file) {
        return (ThriftProgram)this.parse(file, ThriftBaseParser::program);
    }

    public ThriftProgram program(Reader file) {
        try {
            return (ThriftProgram)this.parse(file, ThriftBaseParser::program);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Node parse(Path file, Function<ThriftBaseParser, ParserRuleContext> func) {
        block8: {
            Node node;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
            try {
                node = (Node)this.parse(reader, func);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Cannot read thrift file {}", (Object)file, (Object)e);
                    break block8;
                }
                catch (StackOverflowError e) {
                    LOG.error("File {} is too large to parse.", (Object)file, (Object)e);
                }
            }
            ((Reader)reader).close();
            return node;
        }
        return null;
    }

    protected ThriftBaseParser parser(CommonTokenStream tokenStream) {
        return new ThriftBaseParser((TokenStream)tokenStream);
    }

    protected ThriftBaseLexer lexer(CharStream charStream) {
        return new ThriftBaseLexer(charStream);
    }

    protected AbstractParseTreeVisitor<Node> visitor(CommonTokenStream tokenStream) {
        return new ThriftAstBuilder(tokenStream);
    }

    protected ParseTreeListener parseListener() {
        return new PostProcessor();
    }

    protected ANTLRErrorListener errorListener() {
        return new ThriftErrorListener();
    }
}

