/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.generator;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.reploop.parser.Classpath;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.commons.LevenshteinDistance;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Field;
import org.reploop.parser.thrift.tree.Function;
import org.reploop.parser.thrift.tree.FunctionType;
import org.reploop.parser.thrift.tree.Header;
import org.reploop.parser.thrift.tree.Lang;
import org.reploop.parser.thrift.tree.Namespace;
import org.reploop.parser.thrift.tree.NamespaceScope;
import org.reploop.parser.thrift.tree.ReturnType;
import org.reploop.parser.thrift.tree.Service;
import org.reploop.parser.thrift.tree.ThriftProgram;
import org.reploop.parser.thrift.type.BinaryType;
import org.reploop.parser.thrift.type.FieldType;
import org.reploop.parser.thrift.type.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftBinaryNameResolver
extends AstVisitor<Node, Classpath<ThriftProgram>> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftBinaryNameResolver.class);
    private final Map<String, Set<String>> relations;
    private Path common;
    private static final QualifiedName prefix = QualifiedName.of((String)"qipu");
    private Map<QualifiedName, TreeMap<Integer, List<QualifiedName>>> distanceMap = new HashMap<QualifiedName, TreeMap<Integer, List<QualifiedName>>>();

    public ThriftBinaryNameResolver(Map<String, Set<String>> relations) {
        this.relations = relations;
    }

    @Override
    public Node visitNode(Node node, Classpath<ThriftProgram> context) {
        return node;
    }

    @Override
    public Entity visitEntity(Entity node, Classpath<ThriftProgram> context) {
        return (Entity)this.process(node, context);
    }

    @Override
    public Service visitService(Service node, Classpath<ThriftProgram> context) {
        List<Function> functions = node.getFunctions();
        ImmutableList.Builder fb = ImmutableList.builder();
        if (null != functions) {
            functions.forEach(function -> fb.add((Object)this.visitFunction((Function)function, context)));
        }
        return new Service(node.getParent(), node.getName(), node.getComments(), (List<Function>)fb.build());
    }

    @Override
    public Header visitHeader(Header node, Classpath<ThriftProgram> context) {
        return (Header)this.process(node, context);
    }

    private void addInclude(Classpath<ThriftProgram> context) {
        Path path = context.current();
        Path dir = path.getParent();
        if (null == this.common) {
            this.common = dir.resolve("common.thrift");
        }
        for (Map.Entry<String, Set<String>> entry : this.relations.entrySet()) {
            Set<String> names;
            String filename = entry.getKey();
            if (!path.endsWith(filename) || null == (names = entry.getValue())) continue;
            for (String name : names) {
                Path p = dir.resolve(name);
                if (!Files.exists(p, new LinkOption[0])) continue;
                context.file(p);
            }
        }
        if (null != this.common) {
            context.file(this.common);
        }
    }

    @Override
    public Namespace visitNamespace(Namespace node, Classpath<ThriftProgram> context) {
        NamespaceScope scope = node.getScope();
        if (scope.support(Lang.JAVA)) {
            return new Namespace(scope, QualifiedName.of((QualifiedName)prefix, (String)node.getNamespace()).toString());
        }
        return node;
    }

    @Override
    public ThriftProgram visitProgram(ThriftProgram node, Classpath<ThriftProgram> context) {
        this.addInclude(context);
        List<Header> headers = node.getHeaders();
        ImmutableList.Builder hb = ImmutableList.builder();
        if (null != headers) {
            headers.forEach(header -> hb.add((Object)this.visitHeader((Header)header, context)));
        }
        List<Entity> entities = node.getEntities();
        ImmutableList.Builder eb = ImmutableList.builder();
        if (null != entities) {
            entities.forEach(entity -> eb.add((Object)this.visitEntity((Entity)entity, context)));
        }
        ThriftProgram program = new ThriftProgram(node.getComments(), (List<Header>)hb.build(), (List<Entity>)eb.build());
        program.setFile(node.getFile());
        return program;
    }

    @Override
    public Field visitField(Field field, Classpath<ThriftProgram> context) {
        return this.visitField(null, field, context);
    }

    private QualifiedName convert(String suffix, CaseFormat format) {
        String name = this.name(suffix, format);
        return QualifiedName.of((String)this.type(name, CaseFormat.LOWER_CAMEL));
    }

    private Optional<String> rename(String name) {
        if (name.endsWith("Request")) {
            return Optional.empty();
        }
        return Optional.of(name + "Request");
    }

    private Field visitField(Function function, Field field, Classpath<ThriftProgram> context) {
        if (null != context) {
            Optional<QualifiedName> f;
            HashSet<QualifiedName> names = new HashSet<QualifiedName>();
            String name = this.name(field.getName().suffix());
            QualifiedName qualified = this.convert(name, CaseFormat.LOWER_CAMEL);
            names.add(qualified);
            if (null != function) {
                this.rename(name).ifPresent(n -> names.add(this.convert((String)n, CaseFormat.LOWER_CAMEL)));
                this.rename(function.getName().suffix()).ifPresent(n -> names.add(this.convert((String)n, CaseFormat.LOWER_CAMEL)));
            }
            HashMap localDistanceMap = new HashMap();
            QualifiedName found = null;
            for (QualifiedName qn : names) {
                f = this.resolve(qn, context);
                if (!f.isPresent()) continue;
                found = f.get();
                break;
            }
            if (null == found) {
                for (QualifiedName qn : names) {
                    f = this.closestMatch(qn);
                    if (!f.isPresent()) continue;
                    found = f.get();
                    break;
                }
            }
            if (null == found) {
                found = qualified;
            }
            StructType type = new StructType(found);
            return new Field(field.getComments(), (FieldType)type, field.getFiledId(), name, field.isRequired());
        }
        return field;
    }

    @Override
    public FieldType visitFieldType(FieldType fieldType, Classpath<ThriftProgram> context) {
        return (FieldType)this.process(fieldType, context);
    }

    @Override
    public ReturnType visitReturnType(ReturnType node, Classpath<ThriftProgram> context) {
        return new ReturnType(this.visitFieldType(node.getFieldType(), context));
    }

    @Override
    public FunctionType visitFunctionType(FunctionType node, Classpath<ThriftProgram> context) {
        return (FunctionType)this.process(node, context);
    }

    private String name(String name) {
        return this.name(name, CaseFormat.LOWER_UNDERSCORE);
    }

    private String name(String name, CaseFormat format) {
        return format.to(CaseFormat.LOWER_CAMEL, name);
    }

    private String type(QualifiedName name, CaseFormat format) {
        return this.type(name.suffix(), format);
    }

    private String type(String name) {
        return this.type(name, CaseFormat.LOWER_UNDERSCORE);
    }

    private String type(String name, CaseFormat format) {
        return format.to(CaseFormat.UPPER_CAMEL, name);
    }

    private List<String> names(String name) {
        char[] chars = name.toCharArray();
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char ch : chars) {
            if (sb.length() > 0 && Character.isAlphabetic(ch) && Character.isUpperCase(ch)) {
                names.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(ch);
        }
        names.add(sb.toString());
        Collections.sort(names);
        return names;
    }

    @Override
    public Function visitFunction(Function node, Classpath<ThriftProgram> context) {
        ReturnType returnType;
        FieldType fieldType;
        ImmutableList.Builder fb = ImmutableList.builder();
        node.getExceptions().ifPresent(arg_0 -> ((ImmutableList.Builder)fb).addAll(arg_0));
        fb.add((Object)new Field(Collections.emptyList(), (FieldType)new StructType("TException"), (Integer)0, "e", true));
        fb.add((Object)new Field(Collections.emptyList(), (FieldType)new StructType("InvalidProtocolBufferException"), (Integer)0, "e", true));
        List<Field> params = node.getParameters();
        ImmutableList.Builder pb = ImmutableList.builder();
        if (null != params) {
            params.forEach(field -> pb.add((Object)this.visitField(node, (Field)field, context)));
        }
        ImmutableList parameters = pb.build();
        boolean should = false;
        FunctionType functionType = node.getReturnType();
        if (functionType instanceof ReturnType && (fieldType = (returnType = (ReturnType)functionType).getFieldType()) instanceof BinaryType) {
            should = true;
        }
        if (should) {
            List<Field> fields = this.guessReturnType(node, context, (List<Field>)parameters);
            functionType = this.resolveFunctionType(node, context, fields);
        }
        return new Function(node.getComments(), node.isOneWay(), node.getName(), functionType, (List<Field>)parameters, Optional.of(fb.build()));
    }

    public void set(QualifiedName name, QualifiedName qn, int distance) {
        this.distanceMap.computeIfAbsent(name, n -> new TreeMap()).computeIfAbsent(distance, d -> new ArrayList()).add(qn);
    }

    private Optional<QualifiedName> closestMatch(QualifiedName name) {
        Map.Entry entry = this.distanceMap.computeIfAbsent(name, qn -> new TreeMap()).firstEntry();
        if (null != entry) {
            Integer distance = (Integer)entry.getKey();
            List names = (List)entry.getValue();
            if (null != names && 1 == names.size()) {
                QualifiedName candidate = (QualifiedName)names.get(0);
                LOG.warn("name: {}, candidate: {}, distance: {}", new Object[]{name, candidate, distance});
                return Optional.ofNullable(candidate);
            }
        }
        return Optional.empty();
    }

    private boolean hasExactMatch(QualifiedName name) {
        Integer value = this.distanceMap.computeIfAbsent(name, qn -> new TreeMap()).floorKey(0);
        return null != value;
    }

    private Optional<QualifiedName> resolve(QualifiedName name, Set<QualifiedName> names) {
        for (QualifiedName qn : names) {
            if (null == qn) continue;
            if (qn.endsWith(name)) {
                return Optional.of(qn);
            }
            int distance = LevenshteinDistance.compute((String)name.suffix(), (String)qn.suffix());
            this.set(name, qn, distance);
        }
        return Optional.empty();
    }

    private Optional<QualifiedName> resolve(QualifiedName name, Classpath<ThriftProgram> context) {
        this.distanceMap.clear();
        Optional<QualifiedName> qn = this.resolve(name, context, context.current(), new HashSet<Path>());
        if (qn.isPresent()) {
            return qn;
        }
        return Optional.empty();
    }

    private Optional<QualifiedName> resolve(QualifiedName name, Classpath<ThriftProgram> context, Path file, Set<Path> searched) {
        Set imports;
        if (null != file && !searched.contains(file)) {
            Set names = context.names(file);
            Optional<QualifiedName> qn = this.resolve(name, names);
            searched.add(file);
            if (qn.isPresent()) {
                return qn;
            }
        }
        if (null != (imports = context.files(file))) {
            for (Path path : imports) {
                Optional<QualifiedName> resolved;
                if (null == path || searched.contains(path) || !(resolved = this.resolve(name, context, path, searched)).isPresent()) continue;
                return resolved;
            }
        }
        return Optional.empty();
    }

    private FunctionType resolveFunctionType(Function node, Classpath<ThriftProgram> context, List<Field> sources) {
        Optional<Object> found = Optional.empty();
        for (Field source : sources) {
            FieldType fieldType = source.getFieldType();
            QualifiedName name = fieldType.getName();
            found = this.resolve(name, context);
            if (!found.isPresent()) continue;
            this.set(name, (QualifiedName)found.get(), 0);
            break;
        }
        FunctionType returnType = found.isPresent() ? new ReturnType(new StructType((QualifiedName)found.get())) : node.getReturnType();
        return returnType;
    }

    private List<Field> guessReturnType(Function node, Classpath<ThriftProgram> context, List<Field> parameters) {
        Path current;
        Path cn;
        String type = this.type(node.getName() + "Response", CaseFormat.LOWER_CAMEL);
        Field nameField = new Field(Collections.emptyList(), (FieldType)new StructType(type), (Integer)0, node.getName(), false);
        Field field = (Field)Iterables.getFirst(parameters, (Object)nameField);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (null != field) {
            QualifiedName name = field.getFieldType().getName().replace("Request", "Response");
            fields.add(new Field(field.getComments(), (FieldType)new StructType(name), field.getFiledId(), field.getName(), field.isRequired()));
        }
        if (field != nameField) {
            fields.add(nameField);
        }
        if ((cn = (current = context.current()).getFileName()).endsWith("write_rpc_service.thrift")) {
            fields.add(new Field(Collections.emptyList(), (FieldType)new StructType("WriteResponse"), (Integer)0, "writeResponse", false));
        } else if (cn.endsWith("id_rpc_service.thrift")) {
            fields.add(new Field(Collections.emptyList(), (FieldType)new StructType("IdServiceResponse"), (Integer)0, "idServiceResponse", false));
        } else if (cn.endsWith("query_rpc_service.thrift")) {
            fields.add(new Field(Collections.emptyList(), (FieldType)new StructType("QueryResponse"), (Integer)0, "queryResponse", false));
        }
        fields.sort((o1, o2) -> {
            FieldType ft1 = o1.getFieldType();
            FieldType ft2 = o2.getFieldType();
            return ft1.getName().size() - ft2.getName().size();
        });
        Field previous = null;
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Field now = (Field)it.next();
            if (null != previous) {
                FieldType ft1 = previous.getFieldType();
                FieldType ft2 = now.getFieldType();
                if (ft1.getName().equals((Object)ft2.getName())) {
                    it.remove();
                }
            }
            previous = now;
        }
        return fields;
    }
}

