/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.generator;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reploop.parser.Classpath;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.ThriftParser;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Enum;
import org.reploop.parser.thrift.tree.EnumField;
import org.reploop.parser.thrift.tree.Exception;
import org.reploop.parser.thrift.tree.Field;
import org.reploop.parser.thrift.tree.Function;
import org.reploop.parser.thrift.tree.FunctionType;
import org.reploop.parser.thrift.tree.Header;
import org.reploop.parser.thrift.tree.Include;
import org.reploop.parser.thrift.tree.Lang;
import org.reploop.parser.thrift.tree.Namespace;
import org.reploop.parser.thrift.tree.ReturnType;
import org.reploop.parser.thrift.tree.Service;
import org.reploop.parser.thrift.tree.Struct;
import org.reploop.parser.thrift.tree.ThriftProgram;
import org.reploop.parser.thrift.type.CollectionType;
import org.reploop.parser.thrift.type.FieldType;
import org.reploop.parser.thrift.type.ListType;
import org.reploop.parser.thrift.type.MapType;
import org.reploop.parser.thrift.type.SetType;
import org.reploop.parser.thrift.type.StructType;

public class ThriftClasspathResolver
extends AstVisitor<Node, Classpath<ThriftProgram>> {
    private ThriftParser parser;

    public ThriftClasspathResolver(ThriftParser parser) {
        this.parser = parser;
    }

    @Override
    public Node visitNode(Node node, Classpath<ThriftProgram> context) {
        return node;
    }

    @Override
    public Include visitInclude(Include node, Classpath<ThriftProgram> context) {
        String file = StringUtils.strip((String)node.getFile(), (String)"\"");
        Path current = context.current();
        Path parent = current.getParent();
        QualifiedName namespace = context.namespace();
        Path include = parent.resolve(file).normalize();
        context.files().computeIfAbsent(current, p -> new HashSet()).add(include);
        ThriftProgram program = (ThriftProgram)context.entity(include);
        if (null == program && null != (program = this.parser.program(include))) {
            program.setFile(include);
            context.entity(include, (Object)program);
            context.current(include);
            context.path(include.getParent());
            ThriftProgram tp = this.visitProgram(program, context);
            context.entity(include, (Object)tp);
            context.path(parent);
            context.current(current);
            context.namespace(namespace);
        }
        return node;
    }

    @Override
    public Namespace visitNamespace(Namespace node, Classpath<ThriftProgram> context) {
        String ns;
        if (node.getScope().support(Lang.JAVA) && !Strings.isNullOrEmpty((String)(ns = node.getNamespace()))) {
            context.namespace(QualifiedName.of((String)ns));
        }
        return node;
    }

    @Override
    public MapType visitMapType(MapType mapType, Classpath<ThriftProgram> context) {
        return new MapType(this.visit(mapType.getKeyType(), context, FieldType.class), this.visit(mapType.getValueType(), context, FieldType.class));
    }

    @Override
    public SetType visitSetType(SetType setType, Classpath<ThriftProgram> context) {
        return new SetType(this.visit(setType.getElementType(), context, FieldType.class));
    }

    @Override
    public ListType visitListType(ListType listType, Classpath<ThriftProgram> context) {
        return new ListType(this.visit(listType.getElementType(), context, FieldType.class));
    }

    @Override
    public CollectionType visitCollectionType(CollectionType collectionType, Classpath<ThriftProgram> context) {
        return (CollectionType)this.process(collectionType, context);
    }

    @Override
    public StructType visitStructType(StructType structType, Classpath<ThriftProgram> context) {
        QualifiedName name = structType.getName();
        String structName = name.suffix();
        Optional prefix = name.prefix();
        Optional<String> file = prefix.map(QualifiedName::suffix).map(f -> f + ".thrift");
        Optional<Set> includes = Optional.ofNullable((Set)context.files().get(context.current()));
        if (file.isPresent() && includes.isPresent()) {
            Optional<Path> dep = includes.get().stream().filter(include -> include.endsWith((String)file.get())).findFirst();
            Set names = dep.map(arg_0 -> context.names(arg_0)).orElse(Collections.emptySet());
            Optional<QualifiedName> fullName = names.stream().filter(qualifiedName -> qualifiedName.suffix().equals(structName)).findFirst();
            if (fullName.isPresent()) {
                return new StructType(fullName.get());
            }
        }
        return new StructType(QualifiedName.of((QualifiedName)context.namespace(), (String)structName));
    }

    @Override
    public Entity visitEntity(Entity node, Classpath<ThriftProgram> context) {
        return (Entity)this.process(node, context);
    }

    private QualifiedName fullName(QualifiedName name, Classpath<ThriftProgram> context) {
        return QualifiedName.of((QualifiedName)context.namespace(), (QualifiedName)name);
    }

    @Override
    public Exception visitException(Exception node, Classpath<ThriftProgram> context) {
        QualifiedName fn = this.fullName(node.getName(), context);
        context.name(fn);
        return new Exception(node.getComments(), fn, this.visit(node.getFields(), context, Field.class));
    }

    @Override
    public Enum visitEnum(Enum node, Classpath<ThriftProgram> context) {
        QualifiedName fn = this.fullName(node.getName(), context);
        context.name(fn);
        return new Enum(node.getComments(), fn, this.visit(node.getFields(), context, EnumField.class));
    }

    @Override
    public Struct visitStruct(Struct node, Classpath<ThriftProgram> context) {
        QualifiedName fn = this.fullName(node.getName(), context);
        context.name(fn);
        return new Struct(node.getComments(), fn, this.visit(node.getFields(), context, Field.class));
    }

    @Override
    public Header visitHeader(Header node, Classpath<ThriftProgram> context) {
        return (Header)this.process(node, context);
    }

    private <R extends Node, C extends Node> Optional<R> visitIfPresent(Optional<C> node, Classpath<ThriftProgram> context, Class<R> clazz) {
        return node.map(n -> (Node)this.process((Node)n, context)).map(clazz::cast);
    }

    private <R extends Node, C extends Node> Optional<List<R>> visitIfShow(Optional<List<C>> nodes, Classpath<ThriftProgram> context, Class<R> clazz) {
        return nodes.map(list -> this.visit((List)list, context, clazz));
    }

    private <R extends Node, C extends Node> R visit(C node, Classpath<ThriftProgram> context, Class<R> clazz) {
        Node value = (Node)this.process(node, context);
        if (null != value) {
            return (R)((Node)clazz.cast(value));
        }
        return null;
    }

    private <R extends Node, C extends Node> List<R> visit(List<C> nodes, Classpath<ThriftProgram> context, Class<R> clazz) {
        if (null != nodes) {
            return nodes.stream().filter(Objects::nonNull).map(node -> (Node)this.process((Node)node, context)).filter(Objects::nonNull).map(clazz::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public ThriftProgram visitProgram(ThriftProgram node, Classpath<ThriftProgram> context) {
        Path file = node.getFile();
        ThriftProgram program = new ThriftProgram(node.getComments(), this.visit(node.getHeaders(), context, Header.class), this.visit(node.getEntities(), context, Entity.class));
        program.setFile(file);
        return program;
    }

    @Override
    public Field visitField(Field node, Classpath<ThriftProgram> context) {
        return new Field(node.getComments(), this.visit(node.getFieldType(), context, FieldType.class), node.getFiledId(), node.getName(), node.isRequired());
    }

    @Override
    public FieldType visitFieldType(FieldType fieldType, Classpath<ThriftProgram> context) {
        return (FieldType)this.process(fieldType, context);
    }

    @Override
    public ReturnType visitReturnType(ReturnType node, Classpath<ThriftProgram> context) {
        return new ReturnType(this.visit(node.getFieldType(), context, FieldType.class));
    }

    @Override
    public Function visitFunction(Function node, Classpath<ThriftProgram> context) {
        return new Function(node.getComments(), node.isOneWay(), node.getName(), this.visit(node.getReturnType(), context, FunctionType.class), this.visit(node.getParameters(), context, Field.class), this.visitIfShow(node.getExceptions(), context, Field.class));
    }

    @Override
    public Service visitService(Service node, Classpath<ThriftProgram> context) {
        QualifiedName fn = this.fullName(node.getName(), context);
        context.name(fn);
        return new Service(node.getParent(), fn, node.getComments(), this.visit(node.getFunctions(), context, Function.class));
    }
}

