/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.generator;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Optional;
import org.reploop.parser.Classpath;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.generator.GeneratorContext;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Field;
import org.reploop.parser.thrift.tree.Function;
import org.reploop.parser.thrift.tree.FunctionType;
import org.reploop.parser.thrift.tree.Header;
import org.reploop.parser.thrift.tree.Lang;
import org.reploop.parser.thrift.tree.Namespace;
import org.reploop.parser.thrift.tree.NamespaceScope;
import org.reploop.parser.thrift.tree.ReturnType;
import org.reploop.parser.thrift.tree.Service;
import org.reploop.parser.thrift.tree.ThriftProgram;
import org.reploop.parser.thrift.tree.VoidType;
import org.reploop.parser.thrift.type.FieldType;

public class ThriftCodeGenerator
extends AstVisitor<StringBuilder, GeneratorContext> {
    private StringBuilder content = new StringBuilder();
    private StringBuilder header;
    private Classpath<ThriftProgram> classpath;
    private static final String NEW_LINE = "\r\n";
    private static final char WHITE_SPACE = ' ';
    private static final char COMMA = ',';
    private static final char SEMI_COLON = ';';

    public ThriftCodeGenerator() {
    }

    public ThriftCodeGenerator(Classpath<ThriftProgram> classpath) {
        this.classpath = classpath;
    }

    private StringBuilder indent(GeneratorContext context) {
        return this.indent(context.getIndent());
    }

    private StringBuilder indent(int indent) {
        this.content.append(String.valueOf(' ').repeat(Math.max(0, indent)));
        return this.content;
    }

    private StringBuilder append(char value) {
        return this.content.append(value);
    }

    private StringBuilder append(String value) {
        return this.content.append(value);
    }

    @Override
    public StringBuilder visitFieldType(FieldType fieldType, GeneratorContext context) {
        this.indent(context).append(fieldType.getName());
        return this.content;
    }

    @Override
    public StringBuilder visitField(Field node, GeneratorContext context) {
        this.indent(context);
        this.visitFieldType(node.getFieldType(), GeneratorContext.ZERO_INDENT_CONTEXT);
        this.indent(GeneratorContext.ONE_INDENT_CONTEXT).append(node.getName());
        return this.content;
    }

    @Override
    public StringBuilder visitFunctionType(FunctionType node, GeneratorContext context) {
        return (StringBuilder)this.process(node, context);
    }

    @Override
    public StringBuilder visitVoidType(VoidType node, GeneratorContext context) {
        return this.indent(context).append("void");
    }

    @Override
    public StringBuilder visitReturnType(ReturnType node, GeneratorContext context) {
        return this.indent(context).append(node.getFieldType().getName());
    }

    @Override
    public StringBuilder visitFunction(Function node, GeneratorContext context) {
        Field field;
        this.comments(node.getComments(), context);
        this.indent(context).append("public");
        this.visitFunctionType(node.getReturnType(), GeneratorContext.ONE_INDENT_CONTEXT);
        this.indent(1).append(node.getName()).append("(");
        List<Field> fields = node.getParameters();
        if (null != fields) {
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    this.append(',');
                }
                field = fields.get(i);
                this.visitField(field, GeneratorContext.ZERO_INDENT_CONTEXT);
            }
        }
        this.content.append(")");
        Optional<List<Field>> exceptions = node.getExceptions();
        exceptions.ifPresent(exceptionTable -> {
            if (exceptionTable.size() > 0) {
                for (int i = 0; i < exceptionTable.size(); ++i) {
                    if (i == 0) {
                        this.indent(GeneratorContext.ONE_INDENT_CONTEXT).append("throws");
                    } else {
                        this.content.append(',');
                    }
                    Field field = (Field)exceptionTable.get(i);
                    this.visitFieldType(field.getFieldType(), GeneratorContext.ONE_INDENT_CONTEXT);
                }
            }
        });
        this.content.append("{").append(NEW_LINE);
        context.indent();
        this.indent(context).append("ByteBuffer buff = ByteBuffer.wrap(");
        field = fields.get(0);
        this.content.append(field.getName()).append(".toByteArray());").append(NEW_LINE);
        this.indent(context).append("Connection<TTransport, InetSocketAddress> conn = getConnection();").append(NEW_LINE);
        this.indent(context).append("try {").append(NEW_LINE);
        context.indent();
        this.indent(context).append("buff = newClient(conn).").append(node.getName()).append("(buff);").append(NEW_LINE);
        this.indent(context).append("success(conn); ").append(NEW_LINE);
        this.indent(context).append("return ");
        this.visitFunctionType(node.getReturnType(), GeneratorContext.ZERO_INDENT_CONTEXT);
        this.content.append(".parseFrom(buff.array());").append(NEW_LINE);
        context.dedent();
        this.indent(context).append("} catch (TException e) {").append(NEW_LINE);
        context.indent();
        this.indent(context).append("fail(conn, e);").append(NEW_LINE);
        this.indent(context).append("throw e;").append(NEW_LINE);
        context.dedent();
        this.indent(context).append("}").append(NEW_LINE);
        context.dedent();
        this.indent(context).append("}").append(NEW_LINE);
        return this.content;
    }

    @Override
    public StringBuilder visitNamespace(Namespace node, GeneratorContext context) {
        NamespaceScope scope = node.getScope();
        if (scope.support(Lang.JAVA)) {
            this.indent(context).append("package").append(' ').append(node.getNamespace()).append(';').append(NEW_LINE);
        }
        return this.content;
    }

    private StringBuilder comments(List<String> comments, GeneratorContext context) {
        if (null != comments && comments.size() > 0) {
            for (String comment : comments) {
                this.indent(context).append(comment).append(NEW_LINE);
            }
        }
        return this.content;
    }

    private String name(Service node) {
        return node.getName().suffix() + "Adapter";
    }

    private void constructor(Service node, GeneratorContext context) {
        this.indent(context).append("public ").append(this.name(node)).append("(){").append(NEW_LINE);
        context.indent();
        String name = node.getName().suffix();
        String conf = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name).replace("service", "config").toUpperCase();
        this.indent(context).append("this(CloudZkConfig.").append(conf).append(");").append(NEW_LINE);
        context.dedent();
        this.indent(context).append("}").append(NEW_LINE).append(NEW_LINE);
        this.indent(context).append("public ").append(this.name(node)).append("(RpcConfig config){").append(NEW_LINE);
        context.indent();
        this.indent(context).append("super(config, ").append(node.getName()).append(".Iface.class);").append(NEW_LINE);
        context.dedent();
        this.indent(context).append("}").append(NEW_LINE).append(NEW_LINE);
    }

    @Override
    public StringBuilder visitService(Service node, GeneratorContext context) {
        if (null == this.header || this.header.length() == 0) {
            this.header = this.content;
        }
        this.content = context.code(node).append((CharSequence)this.header);
        this.indent(context).append("import com.google.protobuf.InvalidProtocolBufferException;").append(NEW_LINE);
        this.indent(context).append("import com.reploop.cloud.net.pool.Connection;").append(NEW_LINE);
        this.indent(context).append("import com.reploop.hbase.config.RpcConfig;").append(NEW_LINE);
        this.indent(context).append("import com.reploop.hbase.service.QipuServiceAdapter;").append(NEW_LINE);
        this.indent(context).append("import com.reploop.hbase.util.CloudZkConfig;").append(NEW_LINE);
        this.indent(context).append("import org.apache.thrift.TException;").append(NEW_LINE);
        this.indent(context).append("import org.apache.thrift.transport.TTransport;").append(NEW_LINE);
        this.indent(context).append("import java.net.InetSocketAddress;").append(NEW_LINE);
        this.indent(context).append("import java.nio.ByteBuffer;").append(NEW_LINE);
        this.indent(context).append("import ").append(node.getName()).append(";").append(NEW_LINE);
        node.getName().prefix();
        this.comments(node.getComments(), context);
        String name = this.name(node);
        this.indent(context).append("public class ").append(name).append(" extends QipuServiceAdapter<").append(node.getName().suffix()).append(".Iface>").append("{").append(NEW_LINE);
        this.constructor(node, context.copyThenIndent());
        List<Function> functions = node.getFunctions();
        if (null != functions) {
            functions.forEach(function -> this.visitFunction((Function)function, context.copyThenIndent()));
        }
        this.indent(context).append("}").append(NEW_LINE);
        return this.content;
    }

    @Override
    public StringBuilder visitHeader(Header node, GeneratorContext context) {
        return (StringBuilder)this.process(node, context);
    }

    @Override
    public StringBuilder visitEntity(Entity node, GeneratorContext context) {
        return (StringBuilder)this.process(node, context);
    }

    @Override
    public StringBuilder visitProgram(ThriftProgram node, GeneratorContext context) {
        List<Entity> entities;
        List<Header> headers = node.getHeaders();
        if (null != headers) {
            headers.forEach(header -> this.visitHeader((Header)header, context));
        }
        if (null != (entities = node.getEntities())) {
            entities.forEach(entity -> this.visitEntity((Entity)entity, context));
        }
        return this.content;
    }
}

