/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.tree;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.EnumField;

public class Enum
extends Entity {
    private List<EnumField> fields;

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitEnum(this, context);
    }

    public Enum(String name, List<EnumField> fields) {
        this(name, Collections.emptyList(), fields);
    }

    public Enum(String name, List<String> comments, List<EnumField> fields) {
        super(name, comments);
        this.fields = fields;
    }

    public Enum(List<String> comments, QualifiedName name, List<EnumField> fields) {
        super(name, comments);
        this.fields = fields;
    }

    public List<EnumField> getFields() {
        return this.fields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Enum anEnum = (Enum)o;
        return Objects.equals(this.fields, anEnum.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Override
    public String toString() {
        return "Enum{fields=" + this.fields + "}";
    }
}

