/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.tree;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.Node;

public class EnumField
extends Node {
    private String name;
    private Optional<Integer> index;
    private List<String> comments;

    public EnumField(String name, Optional<Integer> index) {
        this(name, index, Collections.emptyList());
    }

    public EnumField(String name, Optional<Integer> index, List<String> comments) {
        this.name = name;
        this.index = index;
        this.comments = comments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitEnumField(this, context);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumField enumField = (EnumField)o;
        return Objects.equals(this.name, enumField.name) && Objects.equals(this.index, enumField.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.index);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("index", this.index).add("comments", this.comments).toString();
    }
}

