/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static Object findEnumConstant(Class<?> type, String constantName) {
        return ClassUtil.findEnumConstant(type, constantName, true);
    }

    public static Object findEnumConstant(Class<?> type, String constantName, boolean caseSensitive) {
        if (!type.isEnum()) {
            return null;
        }
        for (Object obj : type.getEnumConstants()) {
            String name = obj.toString();
            if ((!caseSensitive || !name.equals(constantName)) && (caseSensitive || !name.equalsIgnoreCase(constantName))) continue;
            return obj;
        }
        return null;
    }

    public static Class<?>[] getClassHierarchy(Class<?> type) {
        ArrayDeque classes = new ArrayDeque();
        for (Class<?> classType = type; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            classes.addFirst(classType);
        }
        return classes.toArray(new Class[0]);
    }

    public static boolean hasBeanMethods(Class<?> type, String propertyName, Class<?> propertyType, boolean caseSensitive) {
        try {
            Method[] methods = ClassUtil.getBeanMethods(type, propertyName, propertyType, caseSensitive);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Method[] getBeanMethods(Class<?> type, String propertyName, Class<?> propertyType, boolean caseSensitive) throws IllegalAccessException, NoSuchMethodException {
        Method[] methods = new Method[]{ClassUtil.getMethod(type, "get" + propertyName, propertyType, null, caseSensitive), ClassUtil.getMethod(type, "set" + propertyName, null, propertyType, caseSensitive)};
        return methods;
    }

    public static Method getMethod(Class<?> type, String name, Class<?> returnType, Class<?> paramType, boolean caseSensitive) throws IllegalAccessException, NoSuchMethodException {
        boolean methodNameFound = false;
        for (Class<?> classType = type; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            for (Method m : classType.getDeclaredMethods()) {
                if ((caseSensitive || !m.getName().equalsIgnoreCase(name)) && (!caseSensitive || !m.getName().equals(name))) continue;
                methodNameFound = true;
                if (returnType != null) {
                    if (!m.getReturnType().equals(returnType)) {
                        throw new NoSuchMethodException("Method '" + name + "' was found in " + type.getSimpleName() + ".class" + ", but the returnType " + m.getReturnType().getSimpleName() + ".class did not match expected " + returnType.getSimpleName() + ".class");
                    }
                } else if (!m.getReturnType().equals(Void.TYPE)) {
                    throw new NoSuchMethodException("Method '" + name + "' was found in " + type.getSimpleName() + ".class" + ", but the returnType " + m.getReturnType().getSimpleName() + ".class was expected to be void");
                }
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramType == null ? paramTypes.length != 0 : paramTypes.length != 1 || !paramTypes[0].equals(paramType)) continue;
                if (!Modifier.isPublic(m.getModifiers())) {
                    throw new IllegalAccessException("Method '" + name + "' was found in " + type.getSimpleName() + ".class " + ", but its not accessible since its " + Modifier.toString(m.getModifiers()));
                }
                return m;
            }
        }
        String signature = "public " + (returnType == null ? "void" : returnType.getName()) + " " + name + "(" + (paramType == null ? "" : paramType.getName()) + ")";
        if (methodNameFound) {
            throw new NoSuchMethodException("Method '" + signature + "' was found in " + type.getSimpleName() + ".class, but signature match failed");
        }
        throw new NoSuchMethodException("Method '" + signature + "' was not found in " + type.getSimpleName() + ".class");
    }
}

