/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.SimpleMap;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigitLookupMap<V>
implements SimpleMap<V> {
    private static final Logger logger = LoggerFactory.getLogger(DigitLookupMap.class);
    private int size = 0;
    private Node<V> root = null;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(String key) throws IllegalArgumentException {
        DigitLookupMap.assertValidGetKey(key);
        int keyLength = key.length();
        if (this.root == null) {
            return null;
        }
        Node<V> currentNode = this.root;
        V bestMatchedValue = currentNode.getPrefixValue();
        for (int i = 0; i < keyLength; ++i) {
            char c = key.charAt(i);
            int index = DigitLookupMap.toNodeArrayIndex(c);
            if (index == -1 || index == 10) {
                throw new IllegalArgumentException("Illegal key [" + key + "]: unsupported char [" + c + "] at index [" + i + "]");
            }
            if (i + 1 == keyLength) {
                Node<V> specificNode = currentNode.getNode(index);
                if (specificNode == null || specificNode.getSpecificValue() == null) continue;
                return specificNode.getSpecificValue();
            }
            if ((currentNode = currentNode.getNode(index)) == null) {
                return bestMatchedValue;
            }
            if (currentNode.getPrefixValue() == null) continue;
            bestMatchedValue = currentNode.getPrefixValue();
        }
        return bestMatchedValue;
    }

    @Override
    public V put(String key, V value) throws IllegalArgumentException {
        DigitLookupMap.assertValidPutKey(key);
        int keyLength = key.length();
        if (this.root == null) {
            this.root = new Node(null);
        }
        Node<V> currentNode = this.root;
        Node<V> nextNode = null;
        V previousValue = null;
        for (int i = 0; i < keyLength; ++i) {
            char c = key.charAt(i);
            int index = DigitLookupMap.toNodeArrayIndex(c);
            if (index == -1) {
                throw new IllegalArgumentException("Illegal key [" + key + "]: unsupported char [" + c + "] at index [" + i + "]");
            }
            if (index == 10) {
                if (i + 1 != keyLength) {
                    throw new IllegalArgumentException("Illegal key [" + key + "]: [*] can only be the last char in key");
                }
                previousValue = currentNode.setPrefixValue(value);
                break;
            }
            nextNode = currentNode.getNode(index);
            if (nextNode == null) {
                nextNode = new Node<V>(currentNode);
                currentNode.setNode(index, nextNode);
            }
            currentNode = nextNode;
            if (i + 1 != keyLength) continue;
            previousValue = currentNode.setSpecificValue(value);
        }
        if (previousValue == null && value != null) {
            ++this.size;
        } else if (previousValue != null && value == null) {
            --this.size;
        }
        return previousValue;
    }

    protected static void assertValidKey(String key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("A null key is not permitted");
        }
        if (key.length() <= 0) {
            throw new IllegalArgumentException("Illegal key [" + key + "]: must be a minimum length of 1");
        }
    }

    protected static void assertValidGetKey(String key) throws NullPointerException, IllegalArgumentException {
        DigitLookupMap.assertValidKey(key);
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            int index = DigitLookupMap.toNodeArrayIndex(c);
            if (index >= 0 && index < 10) continue;
            throw new IllegalArgumentException("Illegal key [" + key + "]: unsupported char [" + c + "] at index [" + i + "]");
        }
    }

    protected static void assertValidPutKey(String key) throws NullPointerException, IllegalArgumentException {
        DigitLookupMap.assertValidKey(key);
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            int index = DigitLookupMap.toNodeArrayIndex(c);
            if (index < 0) {
                throw new IllegalArgumentException("Illegal key [" + key + "]: unsupported char [" + c + "] at index [" + i + "]");
            }
            if (index != 10 || i + 1 == len) continue;
            throw new IllegalArgumentException("Illegal key [" + key + "]: [*] can only be the last char in key");
        }
    }

    protected static int toNodeArrayIndex(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
        }
        return -1;
    }

    public void debug(PrintStream out) {
        this.dumpNode(this.root, 0, -2, out);
    }

    private void dumpNode(Node node, int level, int idx, PrintStream out) {
        if (node == null) {
            return;
        }
        this.printSpaces(level, out);
        if (idx == -2) {
            out.print("ROOT -> ");
        } else {
            out.print(idx + " -> ");
        }
        out.print("S: ");
        if (node.getSpecificValue() != null) {
            out.print(node.getSpecificValue().toString());
        } else {
            out.print("(null)");
        }
        out.print(", W: ");
        if (node.getPrefixValue() != null) {
            out.println(node.getPrefixValue().toString());
        } else {
            out.println("(null)");
        }
        for (int index = 0; index < 10; ++index) {
            this.dumpNode(node.getNode(index), level + 1, index, out);
        }
    }

    private void printSpaces(int count, PrintStream out) {
        for (int i = 0; i < count; ++i) {
            out.print(" ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<V> {
        private Node<V> parent;
        private Node<V>[] children;
        private V specificValue;
        private V prefixValue;

        public Node(Node<V> parent) {
            this.parent = parent;
            this.specificValue = null;
            this.prefixValue = null;
            this.children = null;
        }

        public Node<V> getParent() {
            return this.parent;
        }

        public V getSpecificValue() {
            return this.specificValue;
        }

        public V setSpecificValue(V value) {
            V previousValue = this.specificValue;
            this.specificValue = value;
            return previousValue;
        }

        public V getPrefixValue() {
            return this.prefixValue;
        }

        public V setPrefixValue(V value) {
            V previousValue = this.prefixValue;
            this.prefixValue = value;
            return previousValue;
        }

        public Node<V> getNode(int i) {
            if (this.children == null) {
                return null;
            }
            return this.children[i];
        }

        public void setNode(int i, Node<V> node) {
            if (node == null && this.children == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Node[10];
            }
            this.children[i] = node;
        }
    }
}

