/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.windowing;

import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWindowFuture<K, R, P>
implements WindowFuture<K, R, P> {
    private final WeakReference<Window> window;
    private final ReentrantLock windowLock;
    private final Condition completedCondition;
    private final K key;
    private final R request;
    private final AtomicReference<P> response;
    private final AtomicReference<Throwable> cause;
    private final AtomicInteger callerStateHint;
    private final AtomicBoolean done;
    private final long originalOfferTimeoutMillis;
    private final int windowSize;
    private final long offerTimestamp;
    private final long acceptTimestamp;
    private final long expireTimestamp;
    private final AtomicLong doneTimestamp;

    protected DefaultWindowFuture(Window window, ReentrantLock windowLock, Condition completedCondition, K key, R request, int callerStateHint, long originalOfferTimeoutMillis, int windowSize, long offerTimestamp, long acceptTimestamp, long expireTimestamp) {
        this.window = new WeakReference<Window>(window);
        this.windowLock = windowLock;
        this.completedCondition = completedCondition;
        this.key = key;
        this.request = request;
        this.response = new AtomicReference();
        this.cause = new AtomicReference();
        this.callerStateHint = new AtomicInteger(callerStateHint);
        this.done = new AtomicBoolean(false);
        this.originalOfferTimeoutMillis = originalOfferTimeoutMillis;
        this.windowSize = windowSize;
        this.offerTimestamp = offerTimestamp;
        this.acceptTimestamp = acceptTimestamp;
        this.expireTimestamp = expireTimestamp;
        this.doneTimestamp = new AtomicLong(0L);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public R getRequest() {
        return this.request;
    }

    @Override
    public P getResponse() {
        return this.response.get();
    }

    @Override
    public Throwable getCause() {
        return this.cause.get();
    }

    @Override
    public int getCallerStateHint() {
        return this.callerStateHint.get();
    }

    public void setCallerStateHint(int callerState) {
        this.callerStateHint.set(callerState);
    }

    @Override
    public boolean isCallerWaiting() {
        return this.callerStateHint.get() == 1;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public boolean hasExpireTimestamp() {
        return this.expireTimestamp > 0L;
    }

    @Override
    public long getExpireTimestamp() {
        return this.expireTimestamp;
    }

    @Override
    public long getOfferTimestamp() {
        return this.offerTimestamp;
    }

    @Override
    public long getAcceptTimestamp() {
        return this.acceptTimestamp;
    }

    @Override
    public boolean hasDoneTimestamp() {
        return this.doneTimestamp.get() > 0L;
    }

    @Override
    public long getDoneTimestamp() {
        return this.doneTimestamp.get();
    }

    @Override
    public long getOfferToAcceptTime() {
        return this.acceptTimestamp - this.offerTimestamp;
    }

    @Override
    public long getOfferToDoneTime() {
        if (this.done.get()) {
            return this.doneTimestamp.get() - this.offerTimestamp;
        }
        return -1L;
    }

    @Override
    public long getAcceptToDoneTime() {
        if (this.done.get()) {
            return this.doneTimestamp.get() - this.acceptTimestamp;
        }
        return -1L;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndSignalAll() {
        this.windowLock.lock();
        try {
            this.completedCondition.signalAll();
        }
        finally {
            this.windowLock.unlock();
        }
    }

    @Override
    public boolean isSuccess() {
        return this.done.get() && this.response.get() != null;
    }

    @Override
    public void complete(P response) {
        this.complete(response, System.currentTimeMillis());
    }

    @Override
    public void complete(P response, long doneTimestamp) {
        this.completeHelper(response, doneTimestamp);
        this.safelyRemoveRequestInWindow();
        this.lockAndSignalAll();
    }

    private void safelyRemoveRequestInWindow() {
        Window window0 = (Window)this.window.get();
        if (window0 != null) {
            window0.removeHelper(this.key);
        }
    }

    void completeHelper(P response, long doneTimestamp) {
        if (response == null) {
            throw new IllegalArgumentException("A response cannot be null if trying to complete()");
        }
        if (doneTimestamp <= 0L) {
            throw new IllegalArgumentException("A valid doneTime must be > 0 if trying to complete()");
        }
        if (!this.done.get()) {
            this.response.set(response);
            this.doneTimestamp.set(doneTimestamp);
            this.done.set(true);
        }
    }

    @Override
    public void fail(Throwable t) {
        this.fail(t, System.currentTimeMillis());
    }

    @Override
    public void fail(Throwable t, long doneTimestamp) {
        this.failedHelper(t, doneTimestamp);
        this.safelyRemoveRequestInWindow();
        this.lockAndSignalAll();
    }

    void failedHelper(Throwable t, long doneTimestamp) {
        if (t == null) {
            throw new IllegalArgumentException("A response cannot be null if trying to failed()");
        }
        if (doneTimestamp <= 0L) {
            throw new IllegalArgumentException("A valid doneTimestamp must be > 0 if trying to failed()");
        }
        if (!this.done.get()) {
            this.cause.set(t);
            this.doneTimestamp.set(doneTimestamp);
            this.done.set(true);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.done.get() && this.response.get() == null && this.cause.get() == null;
    }

    @Override
    public void cancel() {
        this.cancel(System.currentTimeMillis());
    }

    @Override
    public void cancel(long doneTimestamp) {
        this.cancelHelper(doneTimestamp);
        this.safelyRemoveRequestInWindow();
        this.lockAndSignalAll();
    }

    void cancelHelper(long doneTimestamp) {
        if (doneTimestamp <= 0L) {
            throw new IllegalArgumentException("A valid doneTimestamp must be > 0 if trying to cancel()");
        }
        if (this.done.compareAndSet(false, true)) {
            this.doneTimestamp.set(doneTimestamp);
        }
    }

    @Override
    public boolean await() throws InterruptedException {
        long remainingTimeoutMillis = this.originalOfferTimeoutMillis - this.getOfferToAcceptTime();
        return this.await(remainingTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        this.setCallerStateHint(1);
        if (this.isDone()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        if (!this.windowLock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS)) {
            this.setCallerStateHint(2);
            return false;
        }
        try {
            while (!this.isDone()) {
                long waitingTime = System.currentTimeMillis() - startTime;
                if (waitingTime >= timeoutMillis) {
                    this.setCallerStateHint(2);
                    boolean bl = false;
                    return bl;
                }
                long remainingWaitTime = timeoutMillis - waitingTime;
                this.completedCondition.await(remainingWaitTime, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.windowLock.unlock();
        }
        return true;
    }
}

