/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.windowing;

import com.cloudhopper.commons.util.UnwrappedWeakReference;
import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.commons.util.windowing.WindowListener;
import java.lang.ref.WeakReference;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowMonitor<K, R, P>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Window.class);
    private final WeakReference<Window<K, R, P>> windowRef;
    private final String monitorThreadName;

    public WindowMonitor(Window<K, R, P> window, String monitorThreadName) {
        this.windowRef = new WeakReference<Window<K, R, P>>(window);
        this.monitorThreadName = monitorThreadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String currentThreadName = null;
        try {
            List expired;
            Window window;
            if (this.monitorThreadName != null) {
                currentThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(this.monitorThreadName);
            }
            if ((window = (Window)this.windowRef.get()) == null) {
                logger.error("The parent Window was garbage collected in this WindowMonitor(): missing call to Window.reset() to stop this monitoring thread (will throw exception to cancel this recurring execution!)");
                throw new IllegalStateException("Parent Window was garbage collected (missing call to Window.reset() somewhere in code)");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Monitor running... (current window.size [" + window.getSize() + "])");
            }
            if ((expired = window.cancelAllExpired()) != null && expired.size() > 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Monitor found [" + expired.size() + "] requests expired");
                }
                for (WindowFuture future : expired) {
                    for (UnwrappedWeakReference listenerRef : window.getListeners()) {
                        WindowListener listener = (WindowListener)listenerRef.get();
                        if (listener == null) {
                            window.removeListener(listener);
                            continue;
                        }
                        try {
                            listener.expired(future);
                        }
                        catch (Throwable t) {
                            logger.error("Ignoring uncaught exception thrown in listener: ", t);
                        }
                    }
                }
            }
        }
        finally {
            if (currentThreadName != null) {
                Thread.currentThread().setName(currentThreadName);
            }
        }
    }
}

