/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPduAsyncResponse
implements PduAsyncResponse {
    private final WindowFuture<Integer, PduRequest, PduResponse> future;

    public DefaultPduAsyncResponse(WindowFuture<Integer, PduRequest, PduResponse> future) {
        this.future = future;
    }

    @Override
    public PduRequest getRequest() {
        return (PduRequest)this.future.getRequest();
    }

    @Override
    public PduResponse getResponse() {
        return (PduResponse)this.future.getResponse();
    }

    @Override
    public int getWindowSize() {
        return this.future.getWindowSize();
    }

    @Override
    public long getWindowWaitTime() {
        return this.future.getOfferToAcceptTime();
    }

    @Override
    public long getResponseTime() {
        return this.future.getAcceptToDoneTime();
    }

    @Override
    public long getEstimatedProcessingTime() {
        long responseTime = this.getResponseTime();
        if (responseTime == 0L || this.future.getWindowSize() == 0) {
            return 0L;
        }
        return responseTime / (long)this.future.getWindowSize();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("smpp_async_resp: seqNum [0x");
        buf.append(HexUtil.toHexString((int)((Integer)this.future.getKey())));
        buf.append("] windowSize [");
        buf.append(this.getWindowSize());
        buf.append("] windowWaitTime [");
        buf.append(this.getWindowWaitTime());
        buf.append(" ms] responseTime [");
        buf.append(this.getResponseTime());
        buf.append(" ms] estProcessingTime [");
        buf.append(this.getEstimatedProcessingTime());
        buf.append(" ms] reqType [");
        buf.append(this.getRequest().getName());
        buf.append("] respType [");
        buf.append(this.getResponse().getName());
        buf.append("]");
        return buf.toString();
    }
}

